/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcontrol.pdm.fw5parser;

import java.io.IOException;
import java.util.Arrays;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

/*
 * Exception performing whole class analysis ignored.
 */
public class SourceLine {
    private int address;
    private int type;
    private byte[] data;

    public void parse(String line) throws DecoderException, IOException {
        byte[] rawData = Hex.decodeHex((char[])line.substring(1).toCharArray());
        if (!SourceLine.verifyLineChecksum((byte[])rawData)) {
            throw new IOException("Checksum calculation failed");
        }
        int length = rawData[0] & 0xFF;
        this.address = SourceLine.bytesToUnsignedInt((byte[])Arrays.copyOfRange(rawData, 1, 3));
        this.type = rawData[3] & 0xFF;
        this.data = Arrays.copyOfRange(rawData, 4, rawData.length - 1);
        if (length != this.data.length) {
            String errorText = "Data size is incorrect; declared " + length + "B, found " + this.data.length + "B";
            throw new IOException(errorText);
        }
    }

    public int getAddress() {
        return this.address;
    }

    public int getType() {
        return this.type;
    }

    public byte[] getData() {
        return this.data;
    }

    public static boolean verifyLineChecksum(byte[] rawData) {
        int expectedChecksum = rawData[rawData.length - 1] & 0xFF;
        int crc = 0;
        for (int i = 0; i < rawData.length - 1; ++i) {
            int b = rawData[i] & 0xFF;
            crc += b;
        }
        crc = 1 + (~crc & 0xFF);
        return (crc &= 0xFF) == expectedChecksum;
    }

    public static int bytesToUnsignedInt(byte[] data) {
        if (data.length > 4) {
            throw new IllegalStateException("An array to be converted to int can be up to 4 characters long.");
        }
        int result = 0;
        for (byte b : data) {
            result <<= 8;
            result += b & 0xFF;
        }
        return result;
    }
}

