/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.utils.controllers.excel;

import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.util.CellAddress;

public class ExcelImportException
extends Exception {
    private static final long serialVersionUID = -3817657320090589302L;
    private final CellAddress cellAddress;
    private String sheetName;

    public ExcelImportException(CellAddress cellAddress, String message) {
        super(message);
        this.cellAddress = cellAddress;
    }

    public ExcelImportException(int row, int col, String message) {
        super(message);
        this.cellAddress = new CellAddress(row, col);
    }

    public ExcelImportException(String sheetName, int row, int col, String message) {
        super(message);
        this.sheetName = sheetName;
        this.cellAddress = new CellAddress(row, col);
    }

    public ExcelImportException(int row, int col, Throwable cause) {
        super(cause);
        this.cellAddress = new CellAddress(row, col);
    }

    public ExcelImportException(String sheetName, int row, int col, Throwable cause) {
        super(cause);
        this.sheetName = sheetName;
        this.cellAddress = new CellAddress(row, col);
    }

    public int getRow() {
        return this.cellAddress.getRow();
    }

    public int getCol() {
        return this.cellAddress.getColumn();
    }

    public String getSheetName() {
        return this.sheetName;
    }

    public String getExcelCellAdress() {
        if (StringUtils.isNotBlank((CharSequence)this.sheetName)) {
            return this.sheetName + "!" + this.cellAddress.toString();
        }
        return this.cellAddress.toString();
    }
}

