/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.reports.revenue;

import de.rtb.pcon.model.PaymentReason;
import de.rtb.pcon.model.PaymentType;
import de.rtb.pcon.ui.controllers.reports.revenue.RevenueEndOfDayReportItemDto;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;

class RevenueEndOfDayRowDto {
    private LocalDate date;
    private String currency;
    private PaymentReason paymentReason;
    private Map<PaymentType, RevenueEndOfDayReportItemDto> items = new LinkedHashMap();

    RevenueEndOfDayRowDto() {
    }

    public Integer getTotalCount() {
        return this.items.values().stream().map(RevenueEndOfDayReportItemDto::getCount).reduce(0, (a, b) -> a + b);
    }

    public BigDecimal getTotalAmount() {
        return this.items.values().stream().map(RevenueEndOfDayReportItemDto::getAmount).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public RevenueEndOfDayReportItemDto createItem(PaymentType pt) {
        RevenueEndOfDayReportItemDto item = new RevenueEndOfDayReportItemDto();
        this.items.put(pt, item);
        return item;
    }

    public RevenueEndOfDayReportItemDto getItem(PaymentType pt) {
        return this.items.getOrDefault(pt, new RevenueEndOfDayReportItemDto());
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE);
        tsb.append("date", (Object)this.date);
        tsb.append("curr", (Object)this.currency);
        tsb.append("method", (Object)this.paymentReason);
        this.items.entrySet().forEach(e -> tsb.append((Object)("[" + String.valueOf(e.getKey()) + ": " + String.valueOf(e.getValue()) + "]")));
        return tsb.toString();
    }

    public LocalDate getDate() {
        return this.date;
    }

    public void setDate(LocalDate date) {
        this.date = date;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public PaymentReason getPaymentReason() {
        return this.paymentReason;
    }

    public void setPaymentReason(PaymentReason paymentReason) {
        this.paymentReason = paymentReason;
    }

    public Map<PaymentType, RevenueEndOfDayReportItemDto> getItems() {
        return this.items;
    }

    public void setItems(Map<PaymentType, RevenueEndOfDayReportItemDto> items) {
        this.items = items;
    }
}

