/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.reports.revenue;

import com.fasterxml.jackson.annotation.JsonGetter;
import de.rtb.pcon.model.PaymentType;
import de.rtb.pcon.ui.controllers.reports.revenue.RevenueEndOfDayReportDto;
import de.rtb.pcon.ui.controllers.reports.revenue.RevenueEndOfDayReportItemDto;
import de.rtb.pcon.ui.controllers.reports.revenue.RevenueEndOfDayRowDto;
import de.rtb.pcon.ui.controllers.reports.revenue.RevenueEndOfDayRowUi;
import de.rtb.pcon.ui.controllers.reports.revenue.UiAmountCount;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;

class RevenueEndOfDayReportUi {
    private List<PaymentType> paymentTypes;
    private List<String> currencies;
    private List<RevenueEndOfDayRowUi> rows;
    private List<RevenueEndOfDayRowUi> summary;

    public RevenueEndOfDayReportUi() {
        this.paymentTypes = List.of();
        this.currencies = List.of();
        this.rows = List.of();
    }

    public RevenueEndOfDayReportUi(RevenueEndOfDayReportDto dm) {
        this.paymentTypes = dm.getPaymentTypes();
        this.currencies = dm.getCurrencies();
        this.rows = new ArrayList(dm.getReport().size());
        for (RevenueEndOfDayRowDto dmRow : dm.getReport()) {
            RevenueEndOfDayRowUi uiRow = new RevenueEndOfDayRowUi();
            uiRow.setDate(dmRow.getDate());
            uiRow.setCurrency(dmRow.getCurrency());
            ArrayList<UiAmountCount> uiItmes = new ArrayList<UiAmountCount>(this.paymentTypes.size());
            for (PaymentType pt : this.paymentTypes) {
                RevenueEndOfDayReportItemDto dmItem = dmRow.getItems().computeIfAbsent(pt, p -> new RevenueEndOfDayReportItemDto());
                uiItmes.add(new UiAmountCount(dmItem.getAmount(), dmItem.getCount()));
            }
            uiItmes.add(new UiAmountCount(dmRow.getTotalAmount(), dmRow.getTotalCount()));
            uiRow.setItems(uiItmes);
            uiRow.setPaymentReason(dmRow.getPaymentReason());
            this.rows.add(uiRow);
        }
        this.summary = new LinkedList();
        for (String curr : this.currencies) {
            RevenueEndOfDayRowUi summaryRow = new RevenueEndOfDayRowUi();
            summaryRow.setCurrency(curr);
            summaryRow.setPaymentReason(null);
            LinkedList<UiAmountCount> summaryItems = new LinkedList<UiAmountCount>();
            for (PaymentType pt : this.paymentTypes) {
                summaryItems.add(new UiAmountCount(dm.periodAmount(curr, pt), dm.periodCount(curr, pt)));
            }
            summaryItems.add(new UiAmountCount(dm.periodTotalAmount(curr), dm.periodTotalCount(curr)));
            summaryRow.setItems(summaryItems);
            this.getSummary().add(summaryRow);
        }
    }

    public List<PaymentType> getPaymentTypes() {
        return this.paymentTypes;
    }

    @JsonGetter(value="paymentTypes")
    public List<Integer> getPaymentTypesJson() {
        if (CollectionUtils.isEmpty((Collection)this.paymentTypes)) {
            return List.of();
        }
        return this.paymentTypes.stream().map(PaymentType::getValue).collect(Collectors.toList());
    }

    public void setPaymentTypes(List<PaymentType> paymentTypes) {
        this.paymentTypes = paymentTypes;
    }

    public List<String> getCurrencies() {
        return this.currencies;
    }

    public void setCurrencies(List<String> currencies) {
        this.currencies = currencies;
    }

    public List<RevenueEndOfDayRowUi> getRows() {
        return this.rows;
    }

    public void setRows(List<RevenueEndOfDayRowUi> rows) {
        this.rows = rows;
    }

    public List<RevenueEndOfDayRowUi> getSummary() {
        return this.summary;
    }

    public void setSummary(List<RevenueEndOfDayRowUi> summary) {
        this.summary = summary;
    }
}

