/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.reports.revenue;

import de.rtb.pcon.core.cash_box.CashBoxMonitorService;
import de.rtb.pcon.model.CashBoxLevel;
import de.rtb.pcon.model.PaymentReason;
import de.rtb.pcon.model.PaymentType;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.ui.controllers.PdmFilterRepository;
import de.rtb.pcon.ui.controllers.reports.revenue.RevenueByPaymentTypeUi;
import de.rtb.pcon.ui.controllers.reports.revenue.RevenueByPdmDto;
import de.rtb.pcon.ui.controllers.reports.revenue.RevenueByPeriodDto;
import de.rtb.pcon.ui.controllers.reports.revenue.RevenueByPeriodUi;
import de.rtb.pcon.ui.controllers.reports.revenue.RevenueEndOfDayReportDto;
import de.rtb.pcon.ui.controllers.reports.revenue.RevenueEndOfDayReportUi;
import de.rtb.pcon.ui.controllers.reports.revenue.RevenueEndOfDayRowDto;
import de.rtb.pcon.ui.controllers.reports.revenue.RevenueReportService;
import de.rtb.pcon.ui.controllers.reports.revenue.UiAmountCount;
import de.rtb.pcon.ui.controllers.reports.revenue.UiCashBoxLevelRow;
import de.rtb.pcon.ui.controllers.reports.revenue.UiRevenueByPdmReport;
import de.rtb.pcon.ui.controllers.reports.revenue.UiRevenueByPdmRow;
import de.rtb.pcon.ui.controllers.reports.revenue.UiSummaryReport;
import de.rtb.pcon.ui.controllers.reports.revenue.UiSummaryRow;
import de.rtb.pcon.ui.services.I18nService;
import de.rtb.pcontrol.ui.controller.UiConvertHelper;
import de.rtb.pcontrol.utils.ExcelExportHelper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.format.annotation.DateTimeFormat;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@PreAuthorize(value="hasRole('ROLE_PCON_ECONOMIST')")
@RequestMapping(path={"/api/pcon/ui/report/revenue"})
public class ReportRevenueController {
    @Autowired
    private PdmFilterRepository pdmFilterRepo;
    @Autowired
    private RevenueReportService revenueReportRepo;
    @Autowired
    private CashBoxMonitorService cashBoxLevelService;
    @Autowired
    private I18nService i18n;

    @Transactional(readOnly=true)
    @GetMapping(value={"pdm.json"})
    public UiRevenueByPdmReport byPdmJson(@RequestParam(value="pdms", required=false) String uiPdmSelector, @RequestParam(value="from") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiFrom, @RequestParam(value="to") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiTo, @RequestParam(value="pt", required=false) List<Integer> uiPaymentTypes, @RequestParam(value="pr", required=false) List<Integer> uiPaymentReasons) {
        List pdms = this.pdmFilterRepo.findBySelector(uiPdmSelector);
        if (pdms.isEmpty()) {
            return UiRevenueByPdmReport.empty();
        }
        List paymentTypes = UiConvertHelper.convertPaymentTypes(uiPaymentTypes);
        List paymentReasons = UiConvertHelper.convertPaymentReasons(uiPaymentReasons);
        ZoneId timeZone = this.i18n.userTimeZoneId();
        OffsetDateTime from = UiConvertHelper.from((LocalDateTime)uiFrom, (ZoneId)timeZone);
        OffsetDateTime to = UiConvertHelper.to((LocalDateTime)uiTo, (ZoneId)timeZone);
        return this.fetchRevenueByPdmData((Collection)pdms, from, to, (Collection)paymentReasons, (Collection)paymentTypes);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"pdm.xlsx"})
    public void byPdmExcel(HttpServletResponse response, @RequestParam(value="pdms", required=false) String uiPdmSelector, @RequestParam(value="from") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiFrom, @RequestParam(value="to") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiTo, @RequestParam(value="pt", required=false) List<Integer> uiPaymentTypes, @RequestParam(value="pr", required=false) List<Integer> uiPaymentReasons) throws IOException {
        List pdms = this.pdmFilterRepo.findBySelector(uiPdmSelector);
        List paymentTypes = UiConvertHelper.convertPaymentTypes(uiPaymentTypes);
        List paymentReasons = UiConvertHelper.convertPaymentReasons(uiPaymentReasons);
        ZoneId timeZone = this.i18n.userTimeZoneId();
        OffsetDateTime from = UiConvertHelper.from((LocalDateTime)uiFrom, (ZoneId)timeZone);
        OffsetDateTime to = UiConvertHelper.to((LocalDateTime)uiTo, (ZoneId)timeZone);
        if (pdms.isEmpty()) {
            return;
        }
        List reportData = this.revenueReportRepo.byPdm((Collection)pdms, from, to, (Collection)paymentReasons, (Collection)paymentTypes);
        Map<String, List<RevenueByPdmDto>> excelData = reportData.stream().collect(Collectors.groupingBy(RevenueByPdmDto::getCurrency));
        ExcelExportHelper eeh = new ExcelExportHelper();
        try (XSSFWorkbook workbook = eeh.createWorkbook();){
            List orderedCurrencies = excelData.keySet().stream().sorted((s1, s2) -> ((List)excelData.get(s2)).size() - ((List)excelData.get(s1)).size()).toList();
            for (String currency : orderedCurrencies) {
                XSSFSheet sheet = eeh.addSheet(currency);
                eeh.addHeaderRow(new String[]{this.i18n.getLocalizedMessage("comp.table.header.label.pdm", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.pdm", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.gac", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.amount", new Object[0])});
                for (RevenueByPdmDto rev : excelData.get(currency)) {
                    eeh.addRow();
                    eeh.addCell().setCellValue((double)rev.getPdm().getNumber().intValue());
                    eeh.addCell().setCellValue(rev.getPdm().getName());
                    eeh.addCell().setCellValue(rev.getPdm().getZone().getArea().getName());
                    eeh.addCell().setCellValue(rev.getAmount().doubleValue());
                }
                ExcelExportHelper.autoFitColums((XSSFSheet)sheet);
            }
            if (workbook.getNumberOfSheets() == 0) {
                workbook.createSheet(this.i18n.getLocalizedMessage("excel.emptySheetName", new Object[0]));
            }
            ExcelExportHelper.setHttpResponseHeaders((HttpServletResponse)response, (String)this.i18n.getLocalizedMessage("report.revenue.byPdm.export.fileName", new Object[0]));
            workbook.write((OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
    }

    UiRevenueByPdmReport fetchRevenueByPdmData(Collection<Pdm> pdms, OffsetDateTime from, OffsetDateTime to, Collection<PaymentReason> paymentReasons, Collection<PaymentType> paymentTypes) {
        List<UiRevenueByPdmRow> reportRows = this.revenueReportRepo.byPdm(pdms, from, to, paymentReasons, paymentTypes).stream().map(UiRevenueByPdmRow::fromDm).toList();
        return new UiRevenueByPdmReport(reportRows);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"end-of-day.json"})
    public RevenueEndOfDayReportUi byEndOfDayJson(@RequestParam(value="pdms", required=false) String uiPdmSelector, @RequestParam(value="from") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiFrom, @RequestParam(value="to") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiTo, @RequestParam(value="pr", required=false) List<Integer> uiPaymentReasons) {
        List pdms = this.pdmFilterRepo.findBySelector(uiPdmSelector);
        List paymentReasons = UiConvertHelper.convertPaymentReasons(uiPaymentReasons);
        ZoneId timeZone = this.i18n.userTimeZoneId();
        OffsetDateTime from = UiConvertHelper.from((LocalDateTime)uiFrom, (ZoneId)timeZone);
        OffsetDateTime to = UiConvertHelper.to((LocalDateTime)uiTo, (ZoneId)timeZone);
        if (pdms.isEmpty()) {
            return new RevenueEndOfDayReportUi();
        }
        RevenueEndOfDayReportDto dmReport = this.revenueReportRepo.byEndOfDay((Collection)pdms, from, to, (Collection)paymentReasons);
        return new RevenueEndOfDayReportUi(dmReport);
    }

    @GetMapping(value={"end-of-day.xlsx"})
    @Transactional(readOnly=true)
    public void endOfDayExcel(HttpServletResponse response, @RequestParam(value="pdms", required=false) String uiPdmSelector, @RequestParam(value="from") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiFrom, @RequestParam(value="to") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiTo, @RequestParam(value="pr", required=false) List<Integer> uiPaymentReasons) throws IOException {
        List pdms = this.pdmFilterRepo.findBySelector(uiPdmSelector);
        List paymentReasons = UiConvertHelper.convertPaymentReasons(uiPaymentReasons);
        ZoneId timeZone = this.i18n.userTimeZoneId();
        OffsetDateTime from = UiConvertHelper.from((LocalDateTime)uiFrom, (ZoneId)timeZone);
        OffsetDateTime to = UiConvertHelper.to((LocalDateTime)uiTo, (ZoneId)timeZone);
        RevenueEndOfDayReportDto endOfDayReport = this.revenueReportRepo.byEndOfDay((Collection)pdms, from, to, (Collection)paymentReasons);
        Map<String, List<RevenueEndOfDayRowDto>> excelData = endOfDayReport.getReport().stream().collect(Collectors.groupingBy(r -> r.getCurrency()));
        ExcelExportHelper eeh = new ExcelExportHelper();
        try (XSSFWorkbook workbook = eeh.createWorkbook();){
            XSSFCellStyle csCentered = workbook.createCellStyle();
            csCentered.setAlignment(HorizontalAlignment.CENTER);
            XSSFCellStyle csBold = eeh.createStyleWithFont();
            csBold.getFont().setBold(true);
            XSSFCellStyle csSecondHeader = eeh.createHeaderRowStyle();
            XSSFCellStyle csSecondHeaderRight = eeh.createHeaderRowStyle();
            csSecondHeaderRight.setAlignment(HorizontalAlignment.RIGHT);
            XSSFCellStyle csDate = eeh.createDateTimeStyle(this.i18n.getLocalizedMessage("excel.format.date.short", new Object[0]));
            List orderedCurrencies = excelData.keySet().stream().sorted((s1, s2) -> ((List)excelData.get(s2)).size() - ((List)excelData.get(s1)).size()).toList();
            for (String currency : orderedCurrencies) {
                List<RevenueEndOfDayRowDto> repRows = excelData.get(currency);
                HashSet usedPaymentTypeSet = new HashSet();
                repRows.forEach(r -> usedPaymentTypeSet.addAll(r.getItems().entrySet().stream().map(Map.Entry::getKey).collect(Collectors.toSet())));
                List usedPaymentTypeList = usedPaymentTypeSet.stream().sorted(this.i18n.comparingString(p -> this.i18n.getEnumLocalText((Enum)p))).toList();
                XSSFSheet sheet = eeh.addSheet(currency);
                eeh.addRow();
                eeh.addCell();
                eeh.addCell();
                eeh.addCell();
                sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, eeh.colIndex()));
                for (PaymentType p2 : usedPaymentTypeList) {
                    eeh.addCell(csCentered).setCellValue(this.i18n.getEnumLocalText((Enum)p2));
                    eeh.addCell();
                    sheet.addMergedRegion(new CellRangeAddress(0, 0, eeh.colIndex() - 1, eeh.colIndex()));
                }
                eeh.addCell(csCentered).setCellValue(this.i18n.getLocalizedMessage("global.label.total", new Object[0]));
                eeh.addCell();
                sheet.addMergedRegion(new CellRangeAddress(0, 0, eeh.colIndex() - 1, eeh.colIndex()));
                eeh.addRow();
                eeh.addCell(csSecondHeader).setCellValue(this.i18n.getLocalizedMessage("global.label.date", new Object[0]));
                eeh.addCell(csSecondHeader).setCellValue(this.i18n.getLocalizedMessage("comp.table.header.label.paymentType", new Object[0]));
                eeh.addCell(csSecondHeader).setCellValue(this.i18n.getLocalizedMessage("global.label.currency", new Object[0]));
                for (int i = 0; i < usedPaymentTypeList.size() + 1; ++i) {
                    eeh.addCell(csSecondHeaderRight).setCellValue(this.i18n.getLocalizedMessage("comp.table.header.label.amount", new Object[0]));
                    eeh.addCell(csSecondHeaderRight).setCellValue(this.i18n.getLocalizedMessage("comp.table.header.label.count", new Object[0]));
                }
                for (RevenueEndOfDayRowDto repRow : repRows) {
                    eeh.addRow();
                    eeh.addCell(csDate, repRow.getDate());
                    eeh.addCell().setCellValue(this.i18n.getEnumLocalText((Enum)repRow.getPaymentReason()));
                    eeh.addCell().setCellValue(this.i18n.getCurrencySymbol(repRow.getCurrency()));
                    for (PaymentType pt : usedPaymentTypeList) {
                        eeh.addCell().setCellValue(repRow.getItem(pt).getAmount().doubleValue());
                        eeh.addCell().setCellValue((double)repRow.getItem(pt).getCount().intValue());
                    }
                    eeh.addCell().setCellValue(repRow.getTotalAmount().doubleValue());
                    eeh.addCell().setCellValue((double)repRow.getTotalCount().longValue());
                }
                eeh.addRow();
                eeh.addCell(csBold).setCellValue(this.i18n.getLocalizedMessage("global.label.total", new Object[0]));
                eeh.addCell().setCellValue("");
                eeh.addCell(csBold).setCellValue(this.i18n.getCurrencySymbol(currency));
                for (PaymentType pt : usedPaymentTypeList) {
                    eeh.addCell(csBold).setCellValue(endOfDayReport.periodAmount(currency, pt).doubleValue());
                    eeh.addCell(csBold).setCellValue((double)endOfDayReport.periodCount(currency, pt).longValue());
                }
                eeh.addCell(csBold).setCellValue(endOfDayReport.periodTotalAmount(currency).doubleValue());
                eeh.addCell(csBold).setCellValue((double)endOfDayReport.periodTotalCount(currency).longValue());
                ExcelExportHelper.autoFitColums((XSSFSheet)sheet);
            }
            ExcelExportHelper.setHttpResponseHeaders((HttpServletResponse)response, (String)this.i18n.getLocalizedMessage("report.revenue.endOfDay.export.fileName", new Object[0]));
            workbook.write((OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"summary.json"})
    public UiSummaryReport bySummaryJson(@RequestParam(value="pdms", required=false) String uiPdmSelector, @RequestParam(value="from") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiFrom, @RequestParam(value="to") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiTo, @RequestParam(value="pr", required=false) List<Integer> uiPaymentReasons) {
        List pdms = this.pdmFilterRepo.findBySelector(uiPdmSelector);
        List paymentReasons = UiConvertHelper.convertPaymentReasons(uiPaymentReasons);
        ZoneId timeZone = this.i18n.userTimeZoneId();
        OffsetDateTime from = UiConvertHelper.from((LocalDateTime)uiFrom, (ZoneId)timeZone);
        OffsetDateTime to = UiConvertHelper.to((LocalDateTime)uiTo, (ZoneId)timeZone);
        if (pdms.isEmpty()) {
            return new UiSummaryReport();
        }
        return UiSummaryReport.fromDm((Collection)this.revenueReportRepo.bySummary((Collection)pdms, from, to, (Collection)paymentReasons));
    }

    @GetMapping(value={"summary.xlsx"})
    @Transactional(readOnly=true)
    public void summaryExcel(HttpServletResponse response, @RequestParam(value="pdms", required=false) String uiPdmSelector, @RequestParam(value="from") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiFrom, @RequestParam(value="to") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiTo, @RequestParam(value="pr", required=false) List<Integer> uiPaymentReasons) throws IOException {
        List pdms = this.pdmFilterRepo.findBySelector(uiPdmSelector);
        List paymentReasons = UiConvertHelper.convertPaymentReasons(uiPaymentReasons);
        ZoneId timeZone = this.i18n.userTimeZoneId();
        OffsetDateTime from = UiConvertHelper.from((LocalDateTime)uiFrom, (ZoneId)timeZone);
        OffsetDateTime to = UiConvertHelper.to((LocalDateTime)uiTo, (ZoneId)timeZone);
        UiSummaryReport report = UiSummaryReport.fromDm((Collection)this.revenueReportRepo.bySummary((Collection)pdms, from, to, (Collection)paymentReasons));
        ExcelExportHelper eeh = new ExcelExportHelper();
        try (XSSFWorkbook workbook = eeh.createWorkbook();){
            XSSFSheet sheet = eeh.addSheet(this.i18n.getLocalizedMessage("report.revenue.summary.export.sheetName", new Object[0]));
            XSSFRow row = eeh.addRow();
            eeh.addCell().setCellValue(this.i18n.getLocalizedMessage("global.device.pdm", new Object[0]));
            eeh.addCell().setCellValue(this.i18n.getLocalizedMessage("global.label.currency", new Object[0]));
            for (PaymentType paymentType : report.getPaymentTypes()) {
                eeh.addCell().setCellValue(this.i18n.getEnumLocalText((Enum)paymentType));
                eeh.addCell();
                sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum(), row.getLastCellNum() - 2, row.getLastCellNum() - 1));
            }
            eeh.addCell().setCellValue(this.i18n.getLocalizedMessage("global.label.total", new Object[0]));
            eeh.addCell();
            sheet.addMergedRegion(new CellRangeAddress(row.getRowNum(), row.getRowNum(), row.getLastCellNum() - 2, row.getLastCellNum() - 1));
            row = eeh.addRow();
            eeh.addCell();
            sheet.addMergedRegion(new CellRangeAddress(0, 1, 0, 0));
            eeh.addCell();
            sheet.addMergedRegion(new CellRangeAddress(0, 1, 1, 1));
            for (PaymentType paymentType : report.getPaymentTypes()) {
                eeh.addCell().setCellValue(this.i18n.getLocalizedMessage("comp.table.header.label.amount", new Object[0]));
                eeh.addCell().setCellValue(this.i18n.getLocalizedMessage("comp.table.header.label.count", new Object[0]));
            }
            eeh.addCell().setCellValue(this.i18n.getLocalizedMessage("comp.table.header.label.amount", new Object[0]));
            eeh.addCell().setCellValue(this.i18n.getLocalizedMessage("comp.table.header.label.count", new Object[0]));
            for (UiSummaryRow line : report.getRows()) {
                eeh.addRow();
                eeh.addCell().setCellValue(line.getPdmName());
                eeh.addCell().setCellValue(this.i18n.getCurrencySymbol(line.getCurrency()));
                for (PaymentType paymentType : report.getPaymentTypes()) {
                    UiAmountCount item = line.getItem(paymentType);
                    eeh.addCell().setCellValue(item.getAmount().doubleValue());
                    eeh.addCell().setCellValue((double)item.getCount().longValue());
                }
                eeh.addCell().setCellValue(line.getTotalAmount().doubleValue());
                eeh.addCell().setCellValue((double)line.getTotalCount().longValue());
            }
            ExcelExportHelper.setHttpResponseHeaders((HttpServletResponse)response, (String)this.i18n.getLocalizedMessage("report.revenue.summary.export.fileName", new Object[0]));
            workbook.write((OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"by-payment-type.json"})
    public List<RevenueByPaymentTypeUi> byPaymentTypeJson(@RequestParam(value="pdms", required=false) String uiPdmSelector, @RequestParam(value="from") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiFrom, @RequestParam(value="to") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiTo, @RequestParam(value="pr", required=false) List<Integer> uiPaymentReasons) {
        List pdms = this.pdmFilterRepo.findBySelector(uiPdmSelector);
        List paymentReasons = UiConvertHelper.convertPaymentReasons(uiPaymentReasons);
        ZoneId timeZone = this.i18n.userTimeZoneId();
        OffsetDateTime from = UiConvertHelper.from((LocalDateTime)uiFrom, (ZoneId)timeZone);
        OffsetDateTime to = UiConvertHelper.to((LocalDateTime)uiTo, (ZoneId)timeZone);
        if (pdms.isEmpty()) {
            return List.of();
        }
        return this.revenueReportRepo.byPaymentType((Collection)pdms, from, to, (Collection)paymentReasons);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"by-payment-type.xlsx"})
    public void byPaymentTypeExcel(HttpServletResponse response, @RequestParam(value="pdms", required=false) String uiPdmSelector, @RequestParam(value="from") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiFrom, @RequestParam(value="to") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiTo, @RequestParam(value="pr", required=false) List<Integer> uiPaymentReasons) throws IOException {
        List pdms = this.pdmFilterRepo.findBySelector(uiPdmSelector);
        List paymentReasons = UiConvertHelper.convertPaymentReasons(uiPaymentReasons);
        ZoneId timeZone = this.i18n.userTimeZoneId();
        OffsetDateTime from = UiConvertHelper.from((LocalDateTime)uiFrom, (ZoneId)timeZone);
        OffsetDateTime to = UiConvertHelper.to((LocalDateTime)uiTo, (ZoneId)timeZone);
        if (pdms.isEmpty()) {
            return;
        }
        List paymentTypesStatisticData = this.revenueReportRepo.byPaymentType((Collection)pdms, from, to, (Collection)paymentReasons);
        Map<String, List<RevenueByPaymentTypeUi>> excelData = paymentTypesStatisticData.stream().collect(Collectors.groupingBy(r -> r.amount().getCurrency()));
        ExcelExportHelper eeh = new ExcelExportHelper();
        try (XSSFWorkbook workbook = eeh.createWorkbook();){
            List orderedCurrencies = excelData.keySet().stream().sorted((s1, s2) -> ((List)excelData.get(s2)).size() - ((List)excelData.get(s1)).size()).toList();
            for (String currency : orderedCurrencies) {
                XSSFSheet sheet = eeh.addSheet(currency);
                eeh.addHeaderRow(new String[]{this.i18n.getLocalizedMessage("comp.table.header.label.paymentReason", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.amount", new Object[0])});
                for (RevenueByPaymentTypeUi rev : excelData.get(currency)) {
                    if (rev.amount().getValue().equals(BigDecimal.ZERO)) continue;
                    eeh.addRow();
                    eeh.addCell().setCellValue(this.i18n.getEnumLocalText((Enum)rev.paymentType()));
                    eeh.addCell().setCellValue(rev.amount().getValue().doubleValue());
                }
                ExcelExportHelper.autoFitColums((XSSFSheet)sheet);
            }
            ExcelExportHelper.setHttpResponseHeaders((HttpServletResponse)response, (String)this.i18n.getLocalizedMessage("report.revenue.paymentType.export.fileName", new Object[0]));
            workbook.write((OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"cash-box-levels.json"})
    public List<UiCashBoxLevelRow> cashBoxLevelsJson(@RequestParam(value="pdms", required=false) String uiPdmSelector) {
        List pdms = this.pdmFilterRepo.findBySelector(uiPdmSelector);
        ZoneId timeZone = this.i18n.userTimeZoneId();
        if (pdms.isEmpty()) {
            return List.of();
        }
        return this.cashBoxLevelService.findForPdms((Collection)pdms).stream().map(x -> UiCashBoxLevelRow.of((CashBoxLevel)x, (ZoneId)timeZone)).toList();
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"cash-box-levels.xlsx"})
    public void cashBoxLevelsExcel(HttpServletResponse response, @RequestParam(value="pdms", required=false) String uiPdmSelector) throws IOException {
        List pdms = this.pdmFilterRepo.findBySelector(uiPdmSelector);
        if (pdms.isEmpty()) {
            return;
        }
        ZoneId timeZone = this.i18n.userTimeZoneId();
        Map<String, List<CashBoxLevel>> excelData = this.cashBoxLevelService.findForPdms((Collection)pdms).stream().sorted((a, b) -> b.getLevel().compareTo(a.getLevel())).collect(Collectors.groupingBy(CashBoxLevel::getCurrency));
        ExcelExportHelper eeh = new ExcelExportHelper();
        try (XSSFWorkbook workbook = eeh.createWorkbook();){
            XSSFCellStyle csDate = eeh.createDateTimeStyle(this.i18n.getLocalizedMessage("excel.format.datetime.short.seconds", new Object[0]));
            List orderedCurrencies = excelData.keySet().stream().sorted((s1, s2) -> ((List)excelData.get(s2)).size() - ((List)excelData.get(s1)).size()).toList();
            for (String currency : orderedCurrencies) {
                XSSFSheet sheet = eeh.addSheet(currency);
                eeh.addHeaderRow(new String[]{this.i18n.getLocalizedMessage("comp.table.header.label.gac", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.number", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.name", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.paymentType", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.amount", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.lastClearing", new Object[0])});
                for (CashBoxLevel rev : excelData.get(currency)) {
                    eeh.addRow();
                    eeh.addCell().setCellValue(rev.getPdm().getZone().getArea().getName());
                    eeh.addCell().setCellValue((double)rev.getPdm().getNumber().intValue());
                    eeh.addCell().setCellValue(rev.getPdm().getName());
                    eeh.addCell().setCellValue(this.i18n.getEnumLocalText((Enum)rev.getPaymentType()));
                    eeh.addCell().setCellValue(rev.getLevel().doubleValue());
                    XSSFCell lastClearingCell = eeh.addCell();
                    Optional.ofNullable(rev.getLastClearing()).map(t -> t.atZoneSameInstant(timeZone).toLocalDateTime()).ifPresentOrElse(t -> {
                        lastClearingCell.setCellValue(t);
                        lastClearingCell.setCellStyle((CellStyle)csDate);
                    }, () -> ((XSSFCell)lastClearingCell).setBlank());
                }
                ExcelExportHelper.autoFitColums((XSSFSheet)sheet);
            }
            ExcelExportHelper.setHttpResponseHeaders((HttpServletResponse)response, (String)this.i18n.getLocalizedMessage("report.revenue.cashBoxLevel.export.fileName", new Object[0]));
            workbook.write((OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"period.json"})
    public Map<String, Object> byPeriodJson(@RequestParam(value="pdms", required=false) String uiPdmSelector, @RequestParam(value="from") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiFrom, @RequestParam(value="to") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiTo, @RequestParam(value="pt", required=false) Set<Integer> uiPaymentTypes, @RequestParam(value="grouping", required=false) String uiGrouping) {
        List pdms = this.pdmFilterRepo.findBySelector(uiPdmSelector);
        if (pdms.isEmpty()) {
            return Map.of();
        }
        List paymentTypes = UiConvertHelper.convertPaymentTypes(uiPaymentTypes);
        ZoneId timeZone = this.i18n.userTimeZoneId();
        OffsetDateTime from = UiConvertHelper.from((LocalDateTime)uiFrom, (ZoneId)timeZone);
        OffsetDateTime to = UiConvertHelper.to((LocalDateTime)uiTo, (ZoneId)timeZone);
        List data = this.revenueReportRepo.revenueByPeriod(from, to, (Collection)paymentTypes, (Collection)pdms, uiGrouping);
        List<RevenueByPeriodUi> table = data.stream().filter(r -> !r.isEmpty()).map(RevenueByPeriodUi::fromDm).sorted((r1, r2) -> Integer.compare(r1.getPeriodOrder(), r2.getPeriodOrder())).toList();
        HashMap revenueChartDbData = new HashMap();
        LinkedList periodNames = new LinkedList();
        data.forEach(rev -> {
            String currency;
            if (rev.isEmpty()) {
                return;
            }
            if (!periodNames.contains(rev.getPeriodLabel())) {
                periodNames.add(rev.getPeriodLabel());
            }
            if (!revenueChartDbData.containsKey(currency = rev.getCurrency())) {
                revenueChartDbData.put(currency, new TreeMap());
            }
            if (!((Map)revenueChartDbData.get(currency)).containsKey(rev.getPeriodLabel())) {
                ((Map)revenueChartDbData.get(currency)).put(rev.getPeriodLabel(), BigDecimal.ZERO);
            }
            BigDecimal sum = (BigDecimal)((Map)revenueChartDbData.get(currency)).get(rev.getPeriodLabel());
            sum = sum.add(rev.getRevenue());
            ((Map)revenueChartDbData.get(currency)).put(rev.getPeriodLabel(), sum);
        });
        ArrayList uiRevenueChart = new ArrayList();
        for (Map.Entry currencySDataSets : revenueChartDbData.entrySet()) {
            String currSymbol = (String)currencySDataSets.getKey();
            Map dataSet = (Map)currencySDataSets.getValue();
            HashMap<String, Object> uiDataSet = new HashMap<String, Object>();
            uiDataSet.put("currency", currSymbol);
            ArrayList<BigDecimal> uiSerieData = new ArrayList<BigDecimal>();
            for (int periodIndex = 0; periodIndex < periodNames.size(); ++periodIndex) {
                String periodName = (String)periodNames.get(periodIndex);
                BigDecimal periodData = (BigDecimal)dataSet.get(periodName);
                if (periodData != null) {
                    uiSerieData.add(periodData);
                    continue;
                }
                uiSerieData.add(BigDecimal.ZERO);
            }
            uiDataSet.put("data", uiSerieData);
            uiRevenueChart.add(uiDataSet);
        }
        Map chart = Map.of("dataSets", uiRevenueChart, "periods", periodNames);
        return Map.of("table", table, "chart", chart);
    }

    @Transactional(readOnly=true)
    @GetMapping(value={"period.xlsx"})
    public void byPeriodExcel(HttpServletResponse response, @RequestParam(value="pdms", required=false) String uiPdmSelector, @RequestParam(value="from") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiFrom, @RequestParam(value="to") @DateTimeFormat(iso=DateTimeFormat.ISO.DATE_TIME) LocalDateTime uiTo, @RequestParam(value="pt", required=false) Set<Integer> uiPaymentTypes, @RequestParam(value="grouping", required=false) String uiGrouping) throws IOException {
        List pdms = this.pdmFilterRepo.findBySelector(uiPdmSelector);
        if (pdms.isEmpty()) {
            return;
        }
        List paymentTypes = UiConvertHelper.convertPaymentTypes(uiPaymentTypes);
        ZoneId timeZone = this.i18n.userTimeZoneId();
        Locale userLocale = this.i18n.getUserLocale();
        OffsetDateTime from = UiConvertHelper.from((LocalDateTime)uiFrom, (ZoneId)timeZone);
        OffsetDateTime to = UiConvertHelper.to((LocalDateTime)uiTo, (ZoneId)timeZone);
        Map<String, List<RevenueByPeriodDto>> excelData = this.revenueReportRepo.revenueByPeriod(from, to, (Collection)paymentTypes, (Collection)pdms, uiGrouping).stream().sorted((r1, r2) -> Integer.compare(r1.getPeriodOrder(), r2.getPeriodOrder())).collect(Collectors.groupingBy(RevenueByPeriodDto::getCurrency));
        ExcelExportHelper eeh = new ExcelExportHelper();
        List orderedCurrencies = excelData.keySet().stream().sorted((s1, s2) -> ((List)excelData.get(s2)).size() - ((List)excelData.get(s1)).size()).toList();
        try (XSSFWorkbook workbook = eeh.createWorkbook();){
            for (String currency : orderedCurrencies) {
                XSSFSheet sheet = eeh.addSheet(currency);
                eeh.addHeaderRow(new String[]{this.i18n.getLocalizedMessage("comp.table.header.label.pdm", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.pdm", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.gac", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.paymentType", new Object[0]), this.i18n.getLocalizedMessage("global.label.time." + uiGrouping.toLowerCase(), new Object[0]), this.i18n.getLocalizedMessage("global.label.currency", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.revenue", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.recharge", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.cancelled", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.reconciliation", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.rtp", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.penalty", new Object[0]), this.i18n.getLocalizedMessage("comp.table.header.label.jeton", new Object[0])});
                DateTimeFormatter localDateTimeShortFormatter = null;
                DateTimeFormatter localDateTimeMediumFormatter = null;
                if ("day".compareToIgnoreCase(uiGrouping) == 0) {
                    localDateTimeShortFormatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.SHORT).withLocale(userLocale);
                    localDateTimeMediumFormatter = DateTimeFormatter.ofLocalizedDate(FormatStyle.MEDIUM).withLocale(userLocale);
                }
                for (RevenueByPeriodDto rev : excelData.get(currency)) {
                    if (rev.isEmpty()) continue;
                    eeh.addRow();
                    eeh.addCell().setCellValue((double)rev.getPdm().getNumber().intValue());
                    eeh.addCell().setCellValue(rev.getPdm().getName());
                    eeh.addCell().setCellValue(rev.getPdm().getZone().getArea().getName());
                    eeh.addCell().setCellValue(this.i18n.getEnumLocalText((Enum)rev.getPaymentType()));
                    XSSFCell periodLabelCell = eeh.addCell();
                    switch (uiGrouping.toLowerCase()) {
                        case "day": {
                            LocalDate dayValue = LocalDate.parse(rev.getPeriodLabel(), localDateTimeShortFormatter);
                            periodLabelCell.setCellValue(dayValue.format(localDateTimeMediumFormatter));
                            break;
                        }
                        case "year": {
                            periodLabelCell.setCellValue((double)Integer.parseInt(rev.getPeriodLabel()));
                            break;
                        }
                        default: {
                            periodLabelCell.setCellValue(rev.getPeriodLabel());
                        }
                    }
                    eeh.addCell().setCellValue(rev.getCurrency());
                    eeh.addCell().setCellValue(rev.getRevenue().doubleValue());
                    eeh.addCell().setCellValue(rev.getPaymentReasonValue(PaymentReason.RECHARGING).doubleValue());
                    eeh.addCell().setCellValue(rev.getPaymentReasonValue(PaymentReason.CANCEL).doubleValue());
                    eeh.addCell().setCellValue(rev.getPaymentReasonValue(PaymentReason.RECONCILIATION).doubleValue());
                    eeh.addCell().setCellValue(rev.getRtpValue().doubleValue());
                    eeh.addCell().setCellValue(rev.getPaymentReasonValue(PaymentReason.PENALTY).doubleValue());
                    eeh.addCell().setCellValue(rev.getPaymentReasonValue(PaymentReason.JETON).doubleValue());
                }
                ExcelExportHelper.autoFitColums((XSSFSheet)sheet);
            }
            ExcelExportHelper.setHttpResponseHeaders((HttpServletResponse)response, (String)this.i18n.getLocalizedMessage("report.revenue.byPeriod.export.fileName", new Object[0]));
            workbook.write((OutputStream)response.getOutputStream());
            response.flushBuffer();
        }
    }
}

