/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.reports.payments;

import de.rtb.pcon.ui.controllers.reports.payments.SaleReportRowCategory;
import de.rtb.pcon.ui.controllers.reports.payments.SaleReportRowCategoryQuaterDow;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.format.TextStyle;
import java.util.Locale;
import java.util.Set;
import java.util.TreeSet;
import org.threeten.extra.Quarter;

class SaleReportRowCategoryQuaterDow
extends SaleReportRowCategory {
    private QuarterDow delegate;

    public SaleReportRowCategoryQuaterDow(int quarter, int dow) {
        this.delegate = new QuarterDow(quarter, dow);
    }

    public int compareTo(SaleReportRowCategory o) {
        if (this.getClass().equals(o.getClass())) {
            SaleReportRowCategoryQuaterDow other = (SaleReportRowCategoryQuaterDow)o;
            return this.delegate.compareTo(other.delegate);
        }
        throw new IllegalStateException("Types " + this.getClass().getName() + " and " + o.getClass().getName() + " are not comparable.");
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.delegate == null ? 0 : this.delegate.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SaleReportRowCategoryQuaterDow other = (SaleReportRowCategoryQuaterDow)obj;
        return !(this.delegate == null ? other.delegate != null : !this.delegate.equals((Object)other.delegate));
    }

    public String toString() {
        return this.delegate.toString();
    }

    public String toLocaleString(Locale locale) {
        return this.delegate.quarter.getDisplayName(TextStyle.SHORT, locale) + " - " + this.delegate.dow.getDisplayName(TextStyle.FULL, locale);
    }

    public static Set<SaleReportRowCategory> generateCategoriesBetween(LocalDate from, LocalDate to) {
        TreeSet<SaleReportRowCategory> yearMonths = new TreeSet<SaleReportRowCategory>();
        LocalDate now = from;
        while (now.isBefore(to) || now.isEqual(to)) {
            Quarter q = Quarter.ofMonth((int)now.getMonthValue());
            DayOfWeek dow = now.getDayOfWeek();
            yearMonths.add((SaleReportRowCategory)new SaleReportRowCategoryQuaterDow(q.getValue(), dow.getValue()));
            now = now.plusDays(1L);
        }
        return yearMonths;
    }
}

