/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.model;

import com.fasterxml.jackson.annotation.JsonGetter;
import de.rtb.pcon.model.PaymentReason;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcon.model.PaymentType;
import de.rtb.pcon.ui.controllers.model.UiBonus;
import de.rtb.pcon.ui.controllers.model.UiMoney;
import de.rtb.pcontrol.utils.DateTimeUtils;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Collection;

public class UiPayment {
    private Integer pdm;
    private PaymentType type;
    private PaymentReason reason;
    private Integer tracer;
    private UiMoney amount;
    private String card;
    private String lpn;
    private LocalDateTime start;
    private LocalDateTime end;
    private LocalDateTime srvTime;
    private Integer ticket;
    private Integer space;
    private String auth;
    private UiBonus bonus;
    private Integer tariff;
    private String data;

    public UiPayment(PaymentTransaction p, ZoneId userTimeZone, boolean protectGdprFields) {
        this.pdm = p.getId().getPdm().getId();
        this.type = p.getPaymentType();
        this.reason = p.getPaymentReason();
        this.tracer = p.getTracerNumber();
        this.amount = new UiMoney(p.getAmount(), p.getCurrency());
        this.card = p.getPaymentCode();
        this.lpn = protectGdprFields ? "" : p.getLpn();
        this.start = DateTimeUtils.toLocalDateTime((OffsetDateTime)p.getId().getPdmTime(), (ZoneId)userTimeZone);
        this.end = DateTimeUtils.toLocalDateTime((OffsetDateTime)p.getParkEndTime(), (ZoneId)userTimeZone);
        this.srvTime = DateTimeUtils.toLocalDateTime((OffsetDateTime)p.getServerTime(), (ZoneId)userTimeZone);
        this.ticket = p.getTicketNumber();
        this.space = p.getPsn();
        this.auth = p.getAuthode();
        this.bonus = UiBonus.of((Collection)p.getBonus(), (String)p.getCurrency());
        this.tariff = p.getTariffInfo() != null ? p.getTariffInfo().getId() : null;
        this.data = p.getData();
    }

    @JsonGetter(value="reason")
    public Integer getReasonJson() {
        return this.reason != null ? Integer.valueOf(this.reason.getValue()) : null;
    }

    @JsonGetter(value="type")
    public Integer getTypeJson() {
        return this.type != null ? Integer.valueOf(this.type.getValue()) : null;
    }

    public Integer getPdm() {
        return this.pdm;
    }

    public void setPdm(Integer pdm) {
        this.pdm = pdm;
    }

    public PaymentType getType() {
        return this.type;
    }

    public void setType(PaymentType type) {
        this.type = type;
    }

    public PaymentReason getReason() {
        return this.reason;
    }

    public void setReason(PaymentReason reason) {
        this.reason = reason;
    }

    public Integer getTracer() {
        return this.tracer;
    }

    public void setTracer(Integer tracer) {
        this.tracer = tracer;
    }

    public UiMoney getAmount() {
        return this.amount;
    }

    public void setAmount(UiMoney amount) {
        this.amount = amount;
    }

    public String getCard() {
        return this.card;
    }

    public void setCard(String card) {
        this.card = card;
    }

    public String getLpn() {
        return this.lpn;
    }

    public void setLpn(String lpn) {
        this.lpn = lpn;
    }

    public LocalDateTime getStart() {
        return this.start;
    }

    public void setStart(LocalDateTime start) {
        this.start = start;
    }

    public LocalDateTime getEnd() {
        return this.end;
    }

    public void setEnd(LocalDateTime end) {
        this.end = end;
    }

    public LocalDateTime getSrvTime() {
        return this.srvTime;
    }

    public void setSrvTime(LocalDateTime srvTime) {
        this.srvTime = srvTime;
    }

    public Integer getTicket() {
        return this.ticket;
    }

    public void setTicket(Integer ticket) {
        this.ticket = ticket;
    }

    public Integer getSpace() {
        return this.space;
    }

    public void setSpace(Integer space) {
        this.space = space;
    }

    public String getAuth() {
        return this.auth;
    }

    public void setAuth(String auth) {
        this.auth = auth;
    }

    public UiBonus getBonus() {
        return this.bonus;
    }

    public void setBonus(UiBonus bonus) {
        this.bonus = bonus;
    }

    public Integer getTariff() {
        return this.tariff;
    }

    public void setTariff(Integer tariff) {
        this.tariff = tariff;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }
}

