/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.model;

import de.rtb.pcon.features.bonus.AppliedBonus;
import de.rtb.pcon.ui.controllers.model.UiMoney;
import java.math.BigDecimal;
import java.time.Duration;
import java.util.Collection;

public class UiBonus {
    private Long duration;
    private UiMoney price;

    public UiBonus(Duration duration, UiMoney price) {
        if (duration != null) {
            this.duration = duration.toMinutes();
        }
        this.price = price;
    }

    public static final UiBonus of(Collection<AppliedBonus> appliedBonusees, String currency) {
        if (appliedBonusees == null) {
            return null;
        }
        Duration durationSum = Duration.ZERO;
        BigDecimal priceSum = BigDecimal.ZERO;
        for (AppliedBonus ab : appliedBonusees) {
            if (ab == null) continue;
            if (ab.getDuration() != null) {
                durationSum = durationSum.plus(ab.getDuration());
            }
            if (ab.getPrice() == null) continue;
            priceSum = priceSum.add(ab.getPrice());
        }
        UiMoney priceUi = new UiMoney(priceSum, currency);
        return new UiBonus(durationSum, priceUi);
    }

    public Long getDuration() {
        return this.duration;
    }

    public void setDuration(Long duration) {
        this.duration = duration;
    }

    public UiMoney getPrice() {
        return this.price;
    }

    public void setPrice(UiMoney price) {
        this.price = price;
    }
}

