/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.logbooks;

import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.Pdm_;
import de.rtb.pcon.model.clearing.Clearing;
import de.rtb.pcon.model.clearing.Clearing_;
import de.rtb.pcon.model.zone.Zone_;
import de.rtb.pcon.ui.controllers.logbooks.LogbookClearingRepository;
import de.rtb.pcon.ui.controllers.logbooks.LogbookRepositotyUtils;
import de.rtb.pcon.ui.controllers.logbooks.SimpleSlice;
import de.rtb.pcon.ui.data_tables.ClearingRequest;
import de.rtb.pcon.ui.data_tables.DataTableColumn;
import de.rtb.pcon.ui.data_tables.DataTableOrder;
import de.rtb.pcon.ui.data_tables.LogbookDataTableRequest;
import de.rtb.pcontrol.ui.controller.UiConvertHelper;
import jakarta.persistence.EntityManager;
import jakarta.persistence.TypedQuery;
import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Expression;
import jakarta.persistence.criteria.Join;
import jakarta.persistence.criteria.JoinType;
import jakarta.persistence.criteria.Order;
import jakarta.persistence.criteria.Path;
import jakarta.persistence.criteria.Predicate;
import jakarta.persistence.criteria.Root;
import jakarta.persistence.criteria.Selection;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class LogbookClearingRepository {
    @Autowired
    private EntityManager entityManager;

    @Transactional(readOnly=true)
    public SimpleSlice<Clearing> findClearings(Collection<Pdm> pdms, ClearingRequest filter) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Clearing.class);
        Root root = criteriaQuery.from(Clearing.class);
        ClearingLogbookJoins joins = this.makeJoins(root);
        Predicate predicate = this.makePredicate(criteriaBuilder, root, pdms, filter);
        List order = this.makeOrder2(criteriaBuilder, root, joins, (LogbookDataTableRequest)filter);
        criteriaQuery.select((Selection)root).where((Expression)predicate).orderBy(order);
        TypedQuery query = this.entityManager.createQuery(criteriaQuery);
        query.setFirstResult(filter.getStart());
        query.setMaxResults(filter.getLength() + 1);
        List result = query.getResultList();
        return new SimpleSlice(result, filter.getLength());
    }

    public Long countClearings(Collection<Pdm> pdms, ClearingRequest filter) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery countQuery = criteriaBuilder.createQuery(Long.class);
        Root root = countQuery.from(Clearing.class);
        Predicate predicate = this.makePredicate(criteriaBuilder, root, pdms, filter);
        countQuery.select((Selection)criteriaBuilder.count((Expression)root)).where((Expression)predicate);
        return (Long)this.entityManager.createQuery(countQuery).getSingleResult();
    }

    @Transactional(readOnly=true)
    public Stream<Clearing> streamClearings(Collection<Pdm> pdms, ClearingRequest filter) {
        CriteriaBuilder criteriaBuilder = this.entityManager.getCriteriaBuilder();
        CriteriaQuery criteriaQuery = criteriaBuilder.createQuery(Clearing.class);
        Root root = criteriaQuery.from(Clearing.class);
        Predicate predicate = this.makePredicate(criteriaBuilder, root, pdms, filter);
        Order order = criteriaBuilder.desc((Expression)root.get(Clearing_.pdmTime));
        criteriaQuery.select((Selection)root).where((Expression)predicate).orderBy(new Order[]{order});
        return this.entityManager.createQuery(criteriaQuery).setHint("org.hibernate.fetchSize", (Object)"10000").getResultStream();
    }

    private Predicate makePredicate(CriteriaBuilder criteriaBuilder, Root<Clearing> root, Collection<Pdm> pdms, ClearingRequest filter) {
        LinkedList<Predicate> predicateList = new LinkedList<Predicate>();
        predicateList.add(root.get(Clearing_.pdm).in(pdms));
        predicateList.add(criteriaBuilder.greaterThanOrEqualTo((Expression)root.get(Clearing_.pdmTime), (Comparable)filter.makeOffsetTimeFrom()));
        predicateList.add(criteriaBuilder.lessThan((Expression)root.get(Clearing_.pdmTime), (Comparable)filter.makeOffsetTimeTo()));
        if (CollectionUtils.isNotEmpty((Collection)filter.getPaymentTypes())) {
            predicateList.add(root.get(Clearing_.paymentType).in((Collection)UiConvertHelper.convertPaymentTypes((Collection)filter.getPaymentTypes())));
        }
        return criteriaBuilder.and(predicateList.toArray(new Predicate[0]));
    }

    private ClearingLogbookJoins makeJoins(Root<Clearing> root) {
        Join pdmJoin = root.join(Clearing_.pdm, JoinType.INNER);
        Join areaJoin = pdmJoin.join(Pdm_.zone, JoinType.INNER).join(Zone_.area, JoinType.INNER);
        return new ClearingLogbookJoins(pdmJoin, areaJoin);
    }

    private List<Order> makeOrder2(CriteriaBuilder cb, Root<Clearing> root, ClearingLogbookJoins joins, LogbookDataTableRequest filter) {
        LinkedList<Order> orders = new LinkedList<Order>();
        for (DataTableOrder dtOrderRule : filter.getOrder()) {
            Path path;
            String fullProperty = ((DataTableColumn)filter.getColumns().get(dtOrderRule.getColumn())).getName();
            String[] propertyParts = StringUtils.split((String)fullProperty, (String)".");
            if (propertyParts.length == 1) {
                path = root.get(propertyParts[0]);
            } else {
                String mainProp = propertyParts[0];
                String subProp = propertyParts[1];
                path = switch (mainProp) {
                    case "pdm" -> joins.pdm().get(subProp);
                    case "area" -> joins.area().get(subProp);
                    default -> throw new IllegalArgumentException("Property : " + mainProp + " is not supported for Clearing object.");
                };
            }
            String direction = dtOrderRule.getDirection();
            orders.add(LogbookRepositotyUtils.createOrderFromString((CriteriaBuilder)cb, (Path)path, (String)direction));
        }
        return orders;
    }
}

