/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.model;

import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.PdmHwDevicePart;
import de.rtb.pcon.model.download.DownloadTarget;
import io.hypersistence.utils.hibernate.type.json.JsonBinaryType;
import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.Table;
import java.time.OffsetDateTime;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.annotations.JdbcType;
import org.hibernate.annotations.Type;
import org.hibernate.dialect.PostgreSQLEnumJdbcType;

@Entity
@Table(name="hw_device", schema="control")
public class PdmHwDevice {
    @Id
    @GeneratedValue(strategy=GenerationType.IDENTITY)
    @Column(name="id")
    private Integer id;
    @Column(name="device_name")
    private String deviceName;
    @Column(name="part_model")
    private String model;
    @Column(name="part", columnDefinition="\"control\".\"device_part\"\n")
    @Enumerated(value=EnumType.STRING)
    @JdbcType(value=PostgreSQLEnumJdbcType.class)
    private PdmHwDevicePart part;
    @Column(name="target", columnDefinition="\"control\".\"download_target\"\n")
    @Enumerated(value=EnumType.STRING)
    @JdbcType(value=PostgreSQLEnumJdbcType.class)
    private DownloadTarget target;
    @Column(name="part_version")
    private String version;
    @Column(name="part_sn")
    private String serialNumber;
    @Column(name="allow_update")
    private boolean updatable = true;
    @Column(name="received")
    private OffsetDateTime timestamp;
    @Type(value=JsonBinaryType.class)
    @Column(name="properties", columnDefinition="jsonb")
    private String properties;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="pdm_id")
    private Pdm pdm;

    public void copyValuesFrom(PdmHwDevice src) {
        this.model = src.model;
        this.version = src.version;
        this.serialNumber = src.serialNumber;
        this.updatable = src.updatable;
        this.properties = src.properties;
    }

    public String toString() {
        String updatableStr = this.updatable ? "updatable" : "not updatable";
        String result = "Device: " + this.deviceName + "/" + String.valueOf(this.part);
        if (this.target != null) {
            result = result + " (" + String.valueOf(this.target) + ", " + updatableStr + "):";
        }
        result = result + " " + this.model;
        if (StringUtils.isNotBlank((CharSequence)this.version)) {
            result = result + ", ver: " + this.version;
        }
        if (StringUtils.isNotBlank((CharSequence)this.serialNumber)) {
            result = result + ", #" + this.serialNumber;
        }
        if (StringUtils.isNotBlank((CharSequence)this.properties)) {
            result = result + ", {" + this.properties + "}";
        }
        return result;
    }

    public String toPathString() {
        return this.getDeviceName() + "/" + String.valueOf(this.getPart());
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getDeviceName() {
        return this.deviceName;
    }

    public void setDeviceName(String deviceName) {
        this.deviceName = deviceName;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        this.model = model;
    }

    public PdmHwDevicePart getPart() {
        return this.part;
    }

    public void setPart(PdmHwDevicePart part) {
        this.part = part;
    }

    public DownloadTarget getTarget() {
        return this.target;
    }

    public void setTarget(DownloadTarget target) {
        this.target = target;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public void setSerialNumber(String serialNumber) {
        this.serialNumber = serialNumber;
    }

    public boolean isUpdatable() {
        return this.updatable;
    }

    public void setUpdatable(boolean updatable) {
        this.updatable = updatable;
    }

    public OffsetDateTime getTimestamp() {
        return this.timestamp;
    }

    public void setTimestamp(OffsetDateTime timestamp) {
        this.timestamp = timestamp;
    }

    public String getProperties() {
        return this.properties;
    }

    public void setProperties(String properties) {
        this.properties = properties;
    }

    public Pdm getPdm() {
        return this.pdm;
    }

    public void setPdm(Pdm pdm) {
        this.pdm = pdm;
    }
}

