/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.model;

import de.rtb.pcon.db.converter.PaymentCardTypeConverter;
import de.rtb.pcon.features.bonus.AppliedBonus;
import de.rtb.pcon.model.PaymentCardType;
import de.rtb.pcon.model.PaymentReason;
import de.rtb.pcon.model.PaymentTransactionId;
import de.rtb.pcon.model.PaymentType;
import de.rtb.pcon.model.RtpSession;
import de.rtb.pcon.model.TariffInfo;
import io.hypersistence.utils.hibernate.type.json.JsonBinaryType;
import jakarta.persistence.Column;
import jakarta.persistence.Convert;
import jakarta.persistence.EmbeddedId;
import jakarta.persistence.Entity;
import jakarta.persistence.EnumType;
import jakarta.persistence.Enumerated;
import jakarta.persistence.FetchType;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.JoinTable;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedAttributeNode;
import jakarta.persistence.NamedEntityGraph;
import jakarta.persistence.OneToMany;
import jakarta.persistence.Table;
import java.math.BigDecimal;
import java.time.OffsetDateTime;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.hibernate.annotations.JdbcType;
import org.hibernate.annotations.Type;
import org.hibernate.dialect.PostgreSQLEnumJdbcType;

@NamedEntityGraph(name="Payment.WithTariff", attributeNodes={@NamedAttributeNode(value="tariffInfo")})
@Entity
@Table(name="payment", schema="control")
public class PaymentTransaction {
    @EmbeddedId
    private PaymentTransactionId id;
    @Column(name="server_ts", nullable=false)
    private OffsetDateTime serverTime;
    @Column(name="pay_reason", columnDefinition="\"control\".\"payment_reason\"\n")
    @Enumerated(value=EnumType.STRING)
    @JdbcType(value=PostgreSQLEnumJdbcType.class)
    private PaymentReason paymentReason;
    @Column(name="pay_type", columnDefinition="\"control\".\"payment_type\"\n")
    @Enumerated(value=EnumType.STRING)
    @JdbcType(value=PostgreSQLEnumJdbcType.class)
    private PaymentType paymentType;
    @Column(name="card_type")
    @Convert(converter=PaymentCardTypeConverter.class)
    private PaymentCardType cardType;
    @Column(name="tracer")
    private int tracerNumber;
    @Column(name="amount", nullable=false)
    private BigDecimal amount;
    @Column(name="expiration_ts")
    private OffsetDateTime parkEndTime;
    @Column(name="ticket_nr")
    private int ticketNumber;
    @Column(name="currency", nullable=false, length=3)
    private String currency;
    @Column(name="lpn", length=25)
    private String lpn;
    @Column(name="card_code")
    private Integer specialCode;
    @Column(name="card_nr", length=19)
    private String paymentCode;
    @Column(name="psn")
    private Integer psn;
    @Column(name="auth_code")
    private String authCode;
    @Type(value=JsonBinaryType.class)
    @Column(name="custom_data", columnDefinition="jsonb")
    private String data;
    @OneToMany(mappedBy="payment")
    private List<AppliedBonus> bonus;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="tariff_info_id")
    private TariffInfo tariffInfo;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinTable(name="payment_ext", schema="control", joinColumns={@JoinColumn(name="ext_pdm_id"), @JoinColumn(name="ext_pay_ts")}, inverseJoinColumns={@JoinColumn(name="base_pdm_id"), @JoinColumn(name="base_pay_ts")})
    private PaymentTransaction basePermit;
    @OneToMany(mappedBy="basePermit", fetch=FetchType.LAZY)
    private List<PaymentTransaction> extPermits;
    @ManyToOne(fetch=FetchType.LAZY)
    @JoinColumn(name="rtp_session")
    private RtpSession rtpSession;

    public PaymentTransactionId getId() {
        return this.id;
    }

    public void setId(PaymentTransactionId id) {
        this.id = id;
    }

    public OffsetDateTime getServerTime() {
        return this.serverTime;
    }

    public void setServerTime(OffsetDateTime serverTime) {
        this.serverTime = serverTime;
    }

    public PaymentReason getPaymentReason() {
        return this.paymentReason;
    }

    public void setPaymentReason(PaymentReason paymentReason) {
        this.paymentReason = paymentReason;
    }

    public PaymentType getPaymentType() {
        return this.paymentType;
    }

    public void setPaymentType(PaymentType paymentType) {
        this.paymentType = paymentType;
    }

    public PaymentCardType getCardType() {
        return this.cardType;
    }

    public void setCardType(PaymentCardType cardType) {
        this.cardType = cardType;
    }

    public int getTracerNumber() {
        return this.tracerNumber;
    }

    public void setTracerNumber(int tracerNumber) {
        this.tracerNumber = tracerNumber;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }

    public OffsetDateTime getParkEndTime() {
        return this.parkEndTime;
    }

    public void setParkEndTime(OffsetDateTime endOfParkingTime) {
        this.parkEndTime = endOfParkingTime;
    }

    public int getTicketNumber() {
        return this.ticketNumber;
    }

    public void setTicketNumber(int ticketNumber) {
        this.ticketNumber = ticketNumber;
    }

    public String getCurrency() {
        return this.currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getLpn() {
        return this.lpn;
    }

    public void setLpn(String lpn) {
        this.lpn = lpn;
    }

    public Integer getSpecialCode() {
        return this.specialCode;
    }

    public void setSpecialCode(Integer specialCode) {
        this.specialCode = specialCode;
    }

    public String getPaymentCode() {
        return this.paymentCode;
    }

    public void setPaymentCode(String paymentCode) {
        this.paymentCode = paymentCode;
    }

    public Integer getPsn() {
        return this.psn;
    }

    public void setPsn(Integer psn) {
        this.psn = psn;
    }

    public String getAuthode() {
        return this.authCode;
    }

    public void setAuthCode(String authCode) {
        this.authCode = authCode;
    }

    public String getData() {
        return this.data;
    }

    public void setData(String data) {
        this.data = data;
    }

    public List<AppliedBonus> getBonus() {
        return this.bonus;
    }

    public void setBonus(List<AppliedBonus> bonus) {
        this.bonus = bonus;
    }

    public TariffInfo getTariffInfo() {
        return this.tariffInfo;
    }

    public void setTariffInfo(TariffInfo tariffInfo) {
        this.tariffInfo = tariffInfo;
    }

    public PaymentTransaction getBasePermit() {
        return this.basePermit;
    }

    public void setBasePermit(PaymentTransaction basePermit) {
        this.basePermit = basePermit;
    }

    public List<PaymentTransaction> getExtPermits() {
        return this.extPermits;
    }

    public void setExtPermits(List<PaymentTransaction> extPermits) {
        this.extPermits = extPermits;
    }

    public RtpSession getRtpSession() {
        return this.rtpSession;
    }

    public void setRtpSession(RtpSession rtpSession) {
        this.rtpSession = rtpSession;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PaymentTransaction other = (PaymentTransaction)obj;
        return Objects.equals(this.id, other.id);
    }

    public String toString() {
        ToStringBuilder tsb = new ToStringBuilder((Object)this, ToStringStyle.NO_CLASS_NAME_STYLE);
        tsb.append("id", (Object)this.getId());
        tsb.append("reason", (Object)this.getPaymentReason());
        tsb.append("type", (Object)this.getPaymentType());
        tsb.append("card", (Object)this.getCardType());
        tsb.append("amount", (Object)(String.valueOf(this.getAmount()) + " " + this.getCurrency()));
        tsb.append("pdm", (Object)this.id.getPdm());
        return tsb.toString();
    }
}

