/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.rao;

import de.rtb.pcon.core.integration.BlockingCallGuard;
import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.partners.rao.RaoConfigDto;
import de.rtb.pcon.features.partners.rao.RaoConfigService;
import de.rtb.pcon.features.partners.rao.RaoProperties;
import de.rtb.pcon.model.Area;
import java.net.URI;
import java.util.Map;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;
import org.springframework.web.client.ResourceAccessException;
import org.springframework.web.client.RestClient;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.util.UriComponentsBuilder;

@Component
class RaoRtrCancelSale
implements RealTimeRequest {
    private final RestClient restClient;
    private final BlockingCallGuard blokcingCallGuard;
    private final RaoConfigService raoConfigService;
    private final RaoProperties raoProps;

    RaoRtrCancelSale(@Qualifier(value="wc3rdPartyApi") RestClient restClient, BlockingCallGuard blokcingCallGuard, RaoConfigService raoConfigService, RaoProperties raoProps) {
        this.restClient = restClient;
        this.blokcingCallGuard = blokcingCallGuard;
        this.raoConfigService = raoConfigService;
        this.raoProps = raoProps;
    }

    public int getId() {
        return 58;
    }

    public String getDescription() {
        return "RAO, cancel sale";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        return this.blokcingCallGuard.webCallExecute(() -> this.doWebCall(ctx));
    }

    private Map<String, Object> doWebCall(RealTimeRequestExecutionContext ctx) {
        Area area = ctx.global().getPdm().getZone().getArea();
        RaoConfigDto config = (RaoConfigDto)this.raoConfigService.fetchConfig(area);
        if (!config.enabled()) {
            return Map.of("ERC", 1);
        }
        Object iniSaleRequest = ctx.getLocalObject("body", Object.class);
        try {
            URI uri = UriComponentsBuilder.fromUriString((String)this.raoProps.getUrl()).pathSegment(new String[]{"pdm", "partner", "rao", "sale", "cancel"}).build().toUri();
            Object confirmSateResponse = ((RestClient.RequestBodySpec)this.restClient.post().uri(uri)).body(iniSaleRequest).retrieve().body(Object.class);
            return Map.of("httpStatus", 200, "body", confirmSateResponse);
        }
        catch (RestClientResponseException e) {
            return Map.of("httpStatus", e.getStatusCode().value(), "body", e.getResponseBodyAsString());
        }
        catch (ResourceAccessException e) {
            return Map.of("ERC", 3, "ERM", "Cannot access Applejack API.");
        }
        catch (RestClientException e) {
            return Map.of("ERC", 3, "ERM", e.getMostSpecificCause().getMessage());
        }
    }
}

