/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.hks;

import de.rtb.pcon.core.integration.BlockingCallGuard;
import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.partners.hks.HksConfigDto;
import de.rtb.pcon.features.partners.hks.HksConfigService;
import de.rtb.pcon.features.partners.hks.HksRtrCancelReceipt;
import de.rtb.pcon.features.partners.hks.HksUtils;
import de.rtb.pcon.model.Area;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestClientResponseException;
import org.springframework.web.client.RestTemplate;

@Component
class HksRtrCancelReceipt
implements RealTimeRequest {
    @Autowired
    @Qualifier(value="rt3rdPartyApi")
    private RestTemplate restTemplate;
    @Autowired
    private BlockingCallGuard blokcingCallGuard;
    @Autowired
    private HksConfigService hksConfigService;

    HksRtrCancelReceipt() {
    }

    public int getId() {
        return 40;
    }

    public String getDescription() {
        return "HKS, cancel receipt";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        return this.blokcingCallGuard.webCallExecute(() -> this.doWebCall(ctx));
    }

    private Map<String, Object> doWebCall(RealTimeRequestExecutionContext ctx) {
        Area area = ctx.global().getPdm().getZone().getArea();
        HksConfigDto config = (HksConfigDto)this.hksConfigService.fetchConfig(area);
        if (!config.enabled()) {
            return Map.of("ERC", 1);
        }
        DtoHksReqCancel cancel = (DtoHksReqCancel)ctx.getLocalObject(DtoHksReqCancel.class);
        HttpEntity entity = new HttpEntity((Object)cancel, (MultiValueMap)HksUtils.basicAuthHeaders((HksConfigDto)config));
        try {
            ResponseEntity responseEntity = this.restTemplate.exchange(config.baseUrl() + "/pos/cancellation/receipt", HttpMethod.POST, entity, DtoHksRespCancel.class, new Object[0]);
            return Map.of("httpStatus", responseEntity.getStatusCode().value(), "body", responseEntity.getBody());
        }
        catch (RestClientResponseException e) {
            return Map.of("httpStatus", e.getStatusCode().value(), "body", e.getResponseBodyAsString());
        }
        catch (RestClientException e) {
            return Map.of("ERC", 3, "ERM", e.getMostSpecificCause().getMessage());
        }
    }
}

