/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.ftt;

import de.rtb.pcon.core.notification.NotificationService;
import de.rtb.pcon.features.partners.PartnerTransportTask;
import de.rtb.pcon.features.partners.PartnerUtils;
import de.rtb.pcon.features.partners.ftt.FttConfigDto;
import de.rtb.pcon.features.partners.ftt.FttResponse;
import de.rtb.pcon.features.partners.ftt.FttTransportTask;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcontrol.utils.LoggerUtils;
import java.net.URI;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Component
@Scope(value="prototype")
class FttTransportTask
implements PartnerTransportTask {
    private static final Logger log = LoggerFactory.getLogger(FttTransportTask.class);
    private final FttConfigDto config;
    private final PaymentTransaction payment;
    @Autowired
    @Qualifier(value="rt3rdPartyApi")
    private RestTemplate restTemplate;
    @Autowired
    private NotificationService notificationService;

    public FttTransportTask(FttConfigDto config, PaymentTransaction payment) {
        this.config = config;
        this.payment = payment;
    }

    public void run() {
        FttRegistrationDto fttRequest = FttRegistrationDto.create((FttConfigDto)this.config, (PaymentTransaction)this.payment);
        if (log.isDebugEnabled()) {
            String pdmTag = StringUtils.capitalize((String)LoggerUtils.log((Pdm)this.payment.getId().getPdm()));
            log.debug("Registering payment #{}, on behalf of {} in zone '{}' to FTT ({}),", new Object[]{this.payment.getId(), pdmTag, fttRequest.zoneUserId(), this.config.url()});
        }
        try {
            URI uri = URI.create(this.config.url());
            RequestEntity reqEntity = ((RequestEntity.BodyBuilder)((RequestEntity.BodyBuilder)((RequestEntity.BodyBuilder)RequestEntity.post((URI)uri).accept(new MediaType[]{MediaType.APPLICATION_JSON})).acceptCharset(new Charset[]{StandardCharsets.UTF_8})).header("Authorization", new String[]{this.config.authorization()})).body((Object)fttRequest);
            FttResponse fttResponse = (FttResponse)this.restTemplate.postForObject(uri, (Object)reqEntity, FttResponse.class);
            if (fttResponse == null) {
                log.error("Null response from FTT!");
                this.sendEmail("Null response from FTT", PartnerUtils.composePaymentRegistrationErrorMessageBody(null, (PaymentTransaction)this.payment, (Object)fttRequest, (Object)fttResponse, (String)"FFT returned null answer."));
                return;
            }
            if (fttResponse.success()) {
                log.info("Payment registered by FTT. UPPID is {}.", (Object)fttResponse.uppid());
            } else {
                log.atError().setMessage("Payment registration by FTT failed: '{}' ({}).").addArgument((Object)fttResponse.errorText()).addArgument((Object)fttResponse.errorCode()).log();
                this.sendEmail("Error by registering payment by FTT", PartnerUtils.composePaymentRegistrationErrorMessageBody(null, (PaymentTransaction)this.payment, (Object)fttRequest, (Object)fttResponse, null));
            }
        }
        catch (Exception e) {
            log.error("General exception by FTT registration", (Throwable)e);
            this.sendEmail("Error by submitting payment to FTT", PartnerUtils.composePaymentRegistrationErrorMessageBody((Exception)e, (PaymentTransaction)this.payment, null, null, null));
        }
    }

    void sendEmail(String subject, String body) {
        if (StringUtils.isNotBlank((CharSequence)this.config.errorEmail())) {
            this.notificationService.sendEmail(this.config.errorEmail(), subject, body + this.signature());
        } else {
            log.warn("FTT registration failure e-mail was not sent, because notification e-mail is not defined in configuration.");
        }
    }

    public void sendTaksRejectedEmail() {
        this.sendEmail("Task rejected from executor.", "#Task for payment registration was rejected from executor!\n\n**Payment**\n%s\n".formatted(PartnerUtils.toJsonLikeString((Object)this.payment, (boolean)true)));
    }
}

