/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.easy_park;

import de.rtb.pcon.features.partners.easy_park.EpConfigDto;
import de.rtb.pcon.features.partners.easy_park.EpConfigJwt;
import de.rtb.pcon.features.partners.easy_park.EpConfigService;
import de.rtb.pcon.model.Area;
import de.rtb.pcontrol.utils.LoggerUtils;
import java.net.URI;
import java.time.OffsetDateTime;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.MediaType;
import org.springframework.http.RequestEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.lang.NonNull;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
class EpAuthService {
    private static final Logger log = LoggerFactory.getLogger(EpAuthService.class);
    public static final String AUTH_HEADER_NAME = "X-Authorization";
    private Map<Integer, EpConfigJwt> jwts = new HashMap();
    @Autowired
    private EpConfigService cfgService;
    @Autowired
    @Qualifier(value="rt3rdPartyApi")
    private RestTemplate restTemplate;

    EpAuthService() {
    }

    @NonNull
    public synchronized String proviceIdToken(@NonNull Area area) {
        EpConfigJwt jwtInfo = this.jwts.computeIfAbsent(area.getId(), k -> this.fetchJwt(area));
        if (jwtInfo.validUntill().isBefore(OffsetDateTime.now())) {
            jwtInfo = this.fetchJwt(area);
            this.jwts.put(area.getId(), jwtInfo);
        }
        return jwtInfo.idToken();
    }

    @NonNull
    public String provideAuthHeaderContent(@NonNull Area area) {
        return EpAuthService.makeAuthHeaderContent((String)this.proviceIdToken(area));
    }

    @NonNull
    public static String makeAuthHeaderContent(@NonNull String jwt) {
        return "Bearer  " + jwt;
    }

    @NonNull
    private EpConfigJwt fetchJwt(@NonNull Area area) {
        if (log.isDebugEnabled()) {
            log.debug("Requesting JWT for EasyPark in {}", (Object)LoggerUtils.log((Area)area));
        }
        EpConfigDto cfg = (EpConfigDto)this.cfgService.fetchConfig(area);
        URI authGateway = URI.create(cfg.auth().authGateway());
        return this.requestJwt(cfg.auth().refreshToken(), authGateway);
    }

    @NonNull
    private EpConfigJwt requestJwt(@NonNull String refreshToken, @NonNull URI authGateway) {
        RequestEntity reqEntity = ((RequestEntity.BodyBuilder)RequestEntity.post((URI)authGateway).accept(new MediaType[]{MediaType.APPLICATION_JSON})).body(Map.of("refreshToken", refreshToken));
        ResponseEntity jwtInfoResponse = this.restTemplate.exchange(reqEntity, EpConfigJwt.class);
        return Optional.ofNullable(jwtInfoResponse).flatMap(resp -> Optional.of((EpConfigJwt)resp.getBody())).map(jwtInfo -> new EpConfigJwt(jwtInfo.idToken(), jwtInfo.validUntill().minusMinutes(10L))).orElseThrow(() -> new NullPointerException("Easy park returned null JWT."));
    }
}

