/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.brain_behind;

import de.rtb.pcon.core.integration.BlockingCallGuard;
import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.partners.brain_behind.BrainBehindUtilService;
import de.rtb.pcon.features.partners.brain_behind.BrbConfigurationService;
import de.rtb.pcon.features.partners.brain_behind.BrbRequestConfigDto;
import de.rtb.pcon.features.partners.brain_behind.PaymentRequestBrbDto;
import de.rtb.pcon.features.partners.brain_behind.PaymentResponseBrbDto;
import de.rtb.pcon.features.partners.brain_behind.PaymentResponseBrbWDto;
import de.rtb.pcon.features.partners.brain_behind.PaymentResponsePdmDto;
import de.rtb.pcon.features.partners.brain_behind.crypto.BrbCryptoService;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.Pdm;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.crypto.NoSuchPaddingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Component;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpServerErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Component
class BrbRtrPay
implements RealTimeRequest {
    private static final Logger log = LoggerFactory.getLogger(BrbRtrPay.class);
    @Autowired
    private BrainBehindUtilService bbUtilsService;
    @Autowired
    @Qualifier(value="rt3rdPartyApi")
    private RestTemplate restTemplate;
    @Autowired
    private BrbConfigurationService configService;
    @Autowired
    private BlockingCallGuard blokcingCallGuard;

    public BrbRtrPay(BrbConfigurationService config) {
        this.configService = config;
    }

    public int getId() {
        return 23;
    }

    public String getDescription() {
        return "Brain behind, payment";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        return this.blokcingCallGuard.webCallExecute(() -> this.doWebCall(ctx));
    }

    private Map<String, Object> doWebCall(RealTimeRequestExecutionContext ctx) {
        String cardNumber = ctx.getLocalString("KNN");
        Pdm pdm = ctx.global().getPdm();
        Area area = ctx.global().getPdm().getZone().getArea();
        Optional pin = ctx.getLocalStringO("PIN");
        boolean usePoints = ctx.getLocalIntegerO("PTS").orElse(0) != 0;
        BigDecimal monValue = ctx.getValue();
        HashMap<String, Object> result = new HashMap<String, Object>();
        BrbRequestConfigDto config = (BrbRequestConfigDto)this.configService.fetchConfig(area);
        if (!config.enabled()) {
            return Map.of("ERC", 1);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.set("provider", config.user());
        headers.set("password", config.passwordWeb());
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setAccept(List.of(MediaType.APPLICATION_JSON));
        try {
            boolean carging = monValue.compareTo(BigDecimal.ZERO) > 0;
            BrbCryptoService crypto = this.configService.cryptoService(config.passwordApi(), config.salt());
            String encryption = crypto.encryptBase64(config.user() + PaymentRequestBrbDto.monetaryValueToCentString((BigDecimal)monValue));
            PaymentRequestBrbDto reqDto = new PaymentRequestBrbDto(cardNumber, BrbConfigurationService.makeTerminalId((Pdm)pdm), carging ? monValue : monValue.negate(), usePoints ? "points" : "amount", carging ? "redeem" : "add", encryption, config.terminalGroup(), pin.orElse(""));
            HttpEntity postHttpEntity = new HttpEntity((Object)reqDto, (MultiValueMap)headers);
            PaymentResponseBrbWDto paymentResponse = (PaymentResponseBrbWDto)this.restTemplate.postForObject("https://loy.brain-behind.com/CU_WebApi.asmx/CU_Consume_Voucher_Terminalgroup", (Object)postHttpEntity, PaymentResponseBrbWDto.class, new Object[0]);
            if (paymentResponse != null && paymentResponse.d() != null) {
                PaymentResponseBrbDto paymentDto = paymentResponse.d();
                if ("OK".equals(paymentDto.status())) {
                    result.put("PAY", PaymentResponsePdmDto.of((PaymentResponseBrbDto)paymentDto));
                } else {
                    result.put("ERC", 3);
                    paymentDto.error().ifPresent(e -> result.put("ERM", paymentDto.error()));
                }
            } else {
                result.put("ERC", 2);
                result.put("ERM", "Response is empty");
            }
        }
        catch (HttpServerErrorException.InternalServerError e2) {
            log.error("Brain behind server error.", (Throwable)e2);
            result.putAll(this.bbUtilsService.mapInternalServerError(e2));
        }
        catch (RestClientException e3) {
            log.error("Error occurred in communication with brain behind.", (Throwable)e3);
            result.put("ERC", 3);
        }
        catch (UnsupportedEncodingException | InvalidKeyException | NoSuchAlgorithmException | NoSuchPaddingException e4) {
            log.error("Error occurred encryption service failed.", (Throwable)e4);
            result.put("ERC", 4);
            result.put("ERM", e4.getMessage());
        }
        catch (ArithmeticException e5) {
            result.put("ERC", 4);
            result.put("ERM", "Value of 'BET' (" + String.valueOf(monValue) + ") can not be expressed in cents, check 'DPA' (" + ctx.getMonetaryScale() + ") from PDM. Reason: " + e5.getMessage() + ".");
        }
        return result;
    }
}

