/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners.brain_behind;

import de.rtb.pcon.features.partners.PartnerConfiguration;
import de.rtb.pcon.features.partners.brain_behind.BrbConfigurationService;
import de.rtb.pcon.features.partners.brain_behind.BrbRequestConfigDto;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.ui.controllers.SecureEntityLoaderService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/pcon/ui/areas/{id}/partners/brain-behind/"})
class BrbController {
    @Autowired
    private BrbConfigurationService cfgService;
    @Autowired
    private SecureEntityLoaderService entityLoader;

    BrbController() {
    }

    @GetMapping(value={"config"})
    @PreAuthorize(value="hasRole('ROLE_PCON_BONUS_MANAGE')")
    @Transactional(readOnly=true)
    public BrbRequestConfigDto getConfig(@PathVariable int id) {
        Area area = this.entityLoader.loadArea(id);
        return (BrbRequestConfigDto)this.cfgService.fetchConfig(area);
    }

    @PostMapping(value={"config"})
    @PreAuthorize(value="hasRole('ROLE_PCON_BONUS_MANAGE')")
    @Transactional
    public void setConfig(@PathVariable int id, @RequestBody BrbRequestConfigDto config) {
        Area area = this.entityLoader.loadArea(id);
        this.cfgService.updateConfig(area, (PartnerConfiguration)config);
    }
}

