/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.partners;

import de.rtb.pcon.features.partners.ForeignRegisterZoneConfig;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcon.model.zone.Zone;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.commons.lang3.RegExUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.builder.ReflectionToStringBuilder;
import org.apache.commons.lang3.builder.ToStringStyle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.NestedExceptionUtils;
import org.springframework.http.HttpHeaders;

/*
 * Exception performing whole class analysis ignored.
 */
public final class PartnerUtils {
    private static final Logger log = LoggerFactory.getLogger(PartnerUtils.class);

    private PartnerUtils() {
    }

    public static <T extends ForeignRegisterZoneConfig> List<T> adjustZones(List<Zone> rtbZones, List<T> partnerZones, IntFunction<T> newPartnerZoneProvider) {
        List partnerZonesSafe = Optional.ofNullable(partnerZones).orElseGet(List::of);
        Predicate<ForeignRegisterZoneConfig> haveMatchingRtbZone = epZone -> rtbZones.stream().anyMatch(rtbZone -> Objects.equals(rtbZone.getId(), epZone.rtbId()));
        Predicate<Zone> haveMatchingEpZoneId = rtbZone -> partnerZonesSafe.stream().anyMatch(epZone -> Objects.equals(rtbZone.getId(), epZone.rtbId()));
        Set zoneIdsToRemove = partnerZonesSafe.stream().filter(haveMatchingRtbZone.negate()).map(ForeignRegisterZoneConfig::rtbId).collect(Collectors.toSet());
        Set zoneIdsToAdd = rtbZones.stream().filter(haveMatchingEpZoneId.negate()).map(Zone::getId).collect(Collectors.toSet());
        LinkedList partnerZonesNew = new LinkedList(partnerZonesSafe);
        if (!zoneIdsToRemove.isEmpty() || !zoneIdsToAdd.isEmpty()) {
            log.atDebug().setMessage("Adjusting Easy Park zones, added: [{}], removed [{}]").addArgument(() -> zoneIdsToAdd.stream().map(Objects::toString).collect(Collectors.joining(","))).addArgument(() -> zoneIdsToRemove.stream().map(Objects::toString).collect(Collectors.joining(","))).log();
            partnerZonesNew.clear();
            List<ForeignRegisterZoneConfig> availableZones = partnerZonesSafe.stream().filter(epZone -> !zoneIdsToRemove.contains(epZone.rtbId())).toList();
            availableZones.forEach(partnerZonesNew::add);
            rtbZones.stream().filter(rtbZone -> zoneIdsToAdd.contains(rtbZone.getId())).forEach(rtbZone -> partnerZonesNew.add((ForeignRegisterZoneConfig)newPartnerZoneProvider.apply(rtbZone.getId())));
        }
        return partnerZonesNew;
    }

    public static String toJsonLikeString(Object o, boolean multiline) {
        String jsonLike = ReflectionToStringBuilder.toString((Object)o, (ToStringStyle)ToStringStyle.JSON_STYLE);
        if (multiline) {
            jsonLike = RegExUtils.replaceFirst((String)jsonLike, (String)"^\\{", (String)"{\n  ");
            jsonLike = StringUtils.replace((String)jsonLike, (String)",\"", (String)",\n  \"");
            jsonLike = RegExUtils.replaceFirst((String)jsonLike, (String)"\\}$", (String)"\n}");
            return "```json%n%s%n```".formatted(jsonLike);
        }
        return jsonLike;
    }

    public static String composePaymentRegistrationErrorMessageBody(Exception ex, PaymentTransaction payment, Object request, Object response, String note) {
        StringBuilder messageBody = new StringBuilder("# Failed to register payment");
        messageBody.append("\n\n**Payment**\n" + PartnerUtils.toJsonLikeString((Object)payment, (boolean)true));
        if (request != null) {
            messageBody.append("\n\n**Request**\n" + PartnerUtils.toJsonLikeString((Object)request, (boolean)true));
        }
        if (response != null) {
            messageBody.append("\n\n**Response**\n" + PartnerUtils.toJsonLikeString((Object)response, (boolean)true));
        }
        if (ex != null) {
            Throwable ex1 = NestedExceptionUtils.getMostSpecificCause((Throwable)ex);
            messageBody.append("\n\n**Exception**\n-Name:" + ex1.getClass().getSimpleName() + "\n-Message: " + ex1.getMessage());
        }
        if (StringUtils.isNotBlank((CharSequence)note)) {
            messageBody.append("\n\n# Note\n" + note);
        }
        return messageBody.toString();
    }

    public static final String basicAuthHeaderContent(String user, String password) {
        HttpHeaders headers = new HttpHeaders();
        headers.setBasicAuth(user, password);
        return (String)headers.getOrEmpty((Object)"Authorization").getFirst();
    }

    public static final HttpHeaders basicAuthHeaders(String user, String password) {
        HttpHeaders headers = new HttpHeaders();
        headers.setBasicAuth(user, password);
        return headers;
    }
}

