/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.multi_tariff_3;

import de.rtb.pcon.features.bonus.multi_tariff_3.BonMt3Repository;
import de.rtb.pcon.features.bonus.multi_tariff_3.BonMt3RuleEntity;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.TariffInfo;
import de.rtb.pcon.model.zone.Zone;
import de.rtb.pcontrol.utils.LoggerUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
class BonMt3Service {
    private static final Logger log = LoggerFactory.getLogger(BonMt3Service.class);
    @Autowired
    private BonMt3Repository bonusRepo;

    BonMt3Service() {
    }

    @Transactional
    public int deletePsnEntries(Zone zone) {
        return this.bonusRepo.deleteByZone(zone);
    }

    @Transactional
    public void addPsnEntry(Zone zone, int psn, TariffInfo tariffInfo) {
        BonMt3RuleEntity mte = new BonMt3RuleEntity();
        mte.setZone(zone);
        mte.setPsn(psn);
        mte.setTariffInfo(tariffInfo);
        this.bonusRepo.save((Object)mte);
    }

    @Transactional(readOnly=true)
    public int findTariffIndex(Integer psn, Pdm pdm) {
        if (pdm.getZone() == null) {
            return -1;
        }
        return this.bonusRepo.findByPsnAndZone(psn, pdm.getZone()).map(rule -> {
            TariffInfo ti = rule.getTariffInfo();
            int tidx = pdm.getTariffInfos().indexOf(ti);
            if (tidx >= 0) {
                return tidx + 1;
            }
            log.warn("{} does not contain expected tariff '{}'", (Object)StringUtils.capitalize((String)LoggerUtils.log((Pdm)pdm)), (Object)ti.getName());
            return -1;
        }).orElse(0);
    }
}

