/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.multi_tariff_3;

import de.rtb.pcon.features.bonus.multi_tariff_3.BonMt3Service;
import de.rtb.pcon.model.TariffInfo;
import de.rtb.pcon.model.appmanagement.User;
import de.rtb.pcon.model.zone.Zone;
import de.rtb.pcon.repositories.TariffInfoRepository;
import de.rtb.pcon.ui.controllers.EntityNotAvailableException;
import de.rtb.pcon.ui.controllers.SecureEntityLoaderService;
import de.rtb.pcon.ui.services.I18nService;
import de.rtb.pcon.ui.services.SecurityService;
import de.rtb.pcon.ui.utils.controllers.excel.ExcelImportException;
import de.rtb.pcon.ui.utils.controllers.excel.ExcelProcessingException;
import de.rtb.pcon.ui.utils.controllers.excel.ExcelProcessingUtilsService;
import de.rtb.pcon.ui.utils.controllers.excel.ExcelUploadResult;
import de.rtb.pcontrol.utils.LoggerUtils;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(path={"/api/pcon/ui/zones/"})
@PreAuthorize(value="hasRole('ROLE_PCON_BONUS_MANAGE')")
class BonMt3Controller {
    private static final Logger logger = LoggerFactory.getLogger(BonMt3Controller.class);
    private static final Logger actionLogger = LoggerFactory.getLogger((String)"de.rtb.pcontrol.audit.actions.");
    @Autowired
    private I18nService i18n;
    @Autowired
    private ExcelProcessingUtilsService excelProcessingUtilsService;
    @Autowired
    private SecureEntityLoaderService entityLoader;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private BonMt3Service mt1Service;
    @Autowired
    private TariffInfoRepository tariffInfoRepo;

    BonMt3Controller() {
    }

    @ExceptionHandler(value={EntityNotAvailableException.class})
    public ResponseEntity<String> handleEntityLoadException(EntityNotAvailableException ex) {
        return new ResponseEntity((Object)ex.getMessage(), (HttpStatusCode)ex.getHttpStatus());
    }

    @ExceptionHandler(value={ExcelProcessingException.class})
    public ResponseEntity<ExcelUploadResult> handleExcelImportException(ExcelProcessingException exWrapper) {
        return this.excelProcessingUtilsService.handleExcelImportException(exWrapper);
    }

    @PostMapping(value={"{id}/bonus/psn/mt1/rules"}, consumes={"multipart/form-data"})
    @PreAuthorize(value="hasRole('ROLE_PCON_BONUS_MANAGE')")
    @Transactional
    public ResponseEntity<ExcelUploadResult> psnMtSetRules(@PathVariable(value="id") int zoneId, @RequestParam(value="rules") MultipartFile file) {
        Iterator iterator;
        block16: {
            Zone zone = this.entityLoader.loadZone(zoneId);
            logger.info("Uploading data for 'PSN multi tariff' bonus");
            Optional validationResult = this.excelProcessingUtilsService.validateEcxelUpload(file);
            if (validationResult.isPresent()) {
                return (ResponseEntity)validationResult.get();
            }
            User user = this.securityService.getCurrentUser();
            List tariffInfos = this.tariffInfoRepo.findAllInZone(zoneId);
            Map tiMap = tariffInfos.stream().collect(Collectors.toMap(TariffInfo::getName, Function.identity()));
            int nrOfDeletedEntries = this.mt1Service.deletePsnEntries(zone);
            logger.debug("Deleted {} entries from PSN multi tariff bonus.", (Object)nrOfDeletedEntries);
            if (actionLogger.isInfoEnabled()) {
                actionLogger.info("The {} has deleted {} PSN multi tariff bonus rules.", (Object)LoggerUtils.log((User)user), (Object)nrOfDeletedEntries);
            }
            Workbook workbook = this.excelProcessingUtilsService.openWorkbookForStreaming(file);
            try {
                logger.info("Importing PSN multi tariff rules ...");
                int ruleCounter = 0;
                for (Sheet sheet : workbook) {
                    for (Row r : sheet) {
                        Cell cellPsn = r.getCell(0);
                        Cell cellTtariffName = r.getCell(1);
                        if (cellPsn == null && cellTtariffName == null) continue;
                        if (cellPsn == null || cellPsn.getCellType() != CellType.NUMERIC || cellPsn.getNumericCellValue() != (double)((int)cellPsn.getNumericCellValue())) {
                            throw new ExcelImportException(sheet.getSheetName(), r.getRowNum(), 0, this.i18n.getLocalizedMessage("document.import.excel.error.cell.psnMustBeNumber", new Object[0]));
                        }
                        if (cellTtariffName == null || cellTtariffName.getCellType() != CellType.STRING) {
                            throw new ExcelImportException(sheet.getSheetName(), r.getRowNum(), 0, this.i18n.getLocalizedMessage("document.import.excel.error.cell.tariffMustBeText", new Object[0]));
                        }
                        int psn = (int)cellPsn.getNumericCellValue();
                        String tariffName = cellTtariffName.getStringCellValue().trim();
                        if (tiMap.keySet().contains(tariffName)) {
                            this.mt1Service.addPsnEntry(zone, psn, (TariffInfo)tiMap.get(tariffName));
                            ++ruleCounter;
                            continue;
                        }
                        throw new ExcelImportException(sheet.getSheetName(), r.getRowNum(), 0, this.i18n.getLocalizedMessage("document.import.excel.error.cell.tariffNotExist", new Object[]{tariffName, zone.getName()}));
                    }
                }
                logger.info("Imported {} rules ...", (Object)ruleCounter);
                if (actionLogger.isInfoEnabled()) {
                    actionLogger.info("The {} has inserted {} PSN multi tariff bonus rules.", (Object)LoggerUtils.log((User)user), (Object)ruleCounter);
                }
                iterator = new ResponseEntity((Object)new ExcelUploadResult(ruleCounter, this.i18n.getLocalizedMessage("document.import.sucess", new Object[0])), (HttpStatusCode)HttpStatus.OK);
                if (workbook == null) break block16;
            }
            catch (Throwable throwable) {
                try {
                    if (workbook != null) {
                        try {
                            workbook.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new ExcelProcessingException((Throwable)e);
                }
            }
            workbook.close();
        }
        return iterator;
    }
}

