/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.gates;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rtb.pcon.core.integration.PdmMessageProcessionException;
import de.rtb.pcon.features.bonus.gates.PresentTicketEntity;
import de.rtb.pcontrol.utils.DateTimeUtils;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;

record PresentTicketPdmDto(@JsonProperty(value="tn") String ticketNumber, @JsonProperty(value="arrival") LocalDateTime arrival, @JsonProperty(value="validFrom") LocalDateTime validFrom, @JsonProperty(value="validTo") LocalDateTime validTo, @JsonProperty(value="type") String ticketType, @JsonProperty(value="data") Map<String, Object> data, @JsonProperty(value="fAllowed") List<String> flagsAllowed, @JsonProperty(value="fEnabled") List<String> flagsEnabled) {
    @JsonProperty(value="tn")
    private final String ticketNumber;
    @JsonProperty(value="arrival")
    private final LocalDateTime arrival;
    @JsonProperty(value="validFrom")
    private final LocalDateTime validFrom;
    @JsonProperty(value="validTo")
    private final LocalDateTime validTo;
    @JsonProperty(value="type")
    private final String ticketType;
    @JsonProperty(value="data")
    private final Map<String, Object> data;
    @JsonProperty(value="fAllowed")
    private final List<String> flagsAllowed;
    @JsonProperty(value="fEnabled")
    private final List<String> flagsEnabled;

    PresentTicketPdmDto(@JsonProperty(value="tn") String ticketNumber, @JsonProperty(value="arrival") LocalDateTime arrival, @JsonProperty(value="validFrom") LocalDateTime validFrom, @JsonProperty(value="validTo") LocalDateTime validTo, @JsonProperty(value="type") String ticketType, @JsonProperty(value="data") Map<String, Object> data, @JsonProperty(value="fAllowed") List<String> flagsAllowed, @JsonProperty(value="fEnabled") List<String> flagsEnabled) {
        this.ticketNumber = ticketNumber;
        this.arrival = arrival;
        this.validFrom = validFrom;
        this.validTo = validTo;
        this.ticketType = ticketType;
        this.data = data;
        this.flagsAllowed = flagsAllowed;
        this.flagsEnabled = flagsEnabled;
    }

    public static PresentTicketPdmDto fromEntity(PresentTicketEntity entity, ZoneId timeZone, ObjectMapper pdmObjectMapper) {
        try {
            LocalDateTime arrival = DateTimeUtils.toLocalDateTime((OffsetDateTime)entity.getArrival(), (ZoneId)timeZone);
            LocalDateTime validFrom = DateTimeUtils.toLocalDateTime((OffsetDateTime)entity.getValidFrom(), (ZoneId)timeZone);
            LocalDateTime validTo = DateTimeUtils.toLocalDateTime((OffsetDateTime)entity.getValidTo(), (ZoneId)timeZone);
            Map data = Map.of();
            if (entity.getData() != null) {
                data = (Map)pdmObjectMapper.readValue(entity.getData(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            return new PresentTicketPdmDto(entity.getTicketNumber(), arrival, validFrom, validTo, entity.getType(), data, entity.getFlagsAllowed(), entity.getFlagsEnabled());
        }
        catch (JsonProcessingException e) {
            throw new PdmMessageProcessionException((Throwable)e);
        }
    }

    @JsonProperty(value="tn")
    public String ticketNumber() {
        return this.ticketNumber;
    }

    @JsonProperty(value="arrival")
    public LocalDateTime arrival() {
        return this.arrival;
    }

    @JsonProperty(value="validFrom")
    public LocalDateTime validFrom() {
        return this.validFrom;
    }

    @JsonProperty(value="validTo")
    public LocalDateTime validTo() {
        return this.validTo;
    }

    @JsonProperty(value="type")
    public String ticketType() {
        return this.ticketType;
    }

    @JsonProperty(value="data")
    public Map<String, Object> data() {
        return this.data;
    }

    @JsonProperty(value="fAllowed")
    public List<String> flagsAllowed() {
        return this.flagsAllowed;
    }

    @JsonProperty(value="fEnabled")
    public List<String> flagsEnabled() {
        return this.flagsEnabled;
    }
}

