/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.disposable;

import de.rtb.pcon.features.bonus.disposable.BonDisRuleEntity;
import de.rtb.pcon.features.bonus.disposable.BonDisRuleRepository;
import de.rtb.pcon.features.bonus.disposable.BonDisService;
import de.rtb.pcon.features.bonus.disposable.BonDisUiBonus;
import de.rtb.pcon.model.appmanagement.User;
import de.rtb.pcon.model.zone.Zone;
import de.rtb.pcon.repositories.TariffInfoRepository;
import de.rtb.pcon.ui.controllers.EntityNotAvailableException;
import de.rtb.pcon.ui.controllers.SecureEntityLoaderService;
import de.rtb.pcon.ui.data_tables.DataTableRequest;
import de.rtb.pcon.ui.data_tables.DataTableResponse;
import de.rtb.pcon.ui.services.I18nService;
import de.rtb.pcon.ui.services.SecurityService;
import de.rtb.pcon.ui.utils.controllers.excel.ExcelProcessingException;
import de.rtb.pcon.ui.utils.controllers.excel.ExcelProcessingUtilsService;
import de.rtb.pcon.ui.utils.controllers.excel.ExcelUploadResult;
import de.rtb.pcontrol.utils.LoggerUtils;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(path={"/api/pcon/ui/zones/{id}/bonus/disposable/"})
@PreAuthorize(value="hasRole('ROLE_PCON_BONUS_MANAGE')")
class BonDisController {
    private static final Logger actionLogger = LoggerFactory.getLogger((String)"de.rtb.pcontrol.audit.actions.");
    @Autowired
    private I18nService i18n;
    @Autowired
    private BonDisService disposableBonusService;
    @Autowired
    private BonDisRuleRepository disposableBonusRepo;
    @Autowired
    private ExcelProcessingUtilsService excelProcessingUtilsService;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private SecureEntityLoaderService entityLoader;
    @Autowired
    private TariffInfoRepository tariffInfoRepo;

    BonDisController() {
    }

    @ExceptionHandler(value={EntityNotAvailableException.class})
    public ResponseEntity<String> handleEntityLoadException(EntityNotAvailableException ex) {
        return new ResponseEntity((Object)ex.getMessage(), (HttpStatusCode)ex.getHttpStatus());
    }

    @ExceptionHandler(value={ExcelProcessingException.class})
    public ResponseEntity<ExcelUploadResult> handleExcelImportException(ExcelProcessingException exWrapper) {
        return this.excelProcessingUtilsService.handleExcelImportException(exWrapper);
    }

    @PostMapping(value={"codes"})
    @PreAuthorize(value="hasRole('ROLE_PCON_BONUS_MANAGE')")
    @Transactional
    public ResponseEntity<ExcelUploadResult> uploadExcel(@PathVariable(value="id") int zoneId, @RequestParam(value="rules") MultipartFile file) {
        Zone zone = this.entityLoader.loadZone(zoneId);
        List tariffs = this.tariffInfoRepo.findAllInZone(zoneId);
        ZoneId timeZone = ZoneId.of(zone.getArea().getTimeZoneName());
        User user = this.securityService.getCurrentUser();
        int numberOfInsertedCodes = 0;
        try (Workbook workbook = this.excelProcessingUtilsService.openWorkbookForStreaming(file);){
            Sheet sheet = workbook.getSheetAt(0);
            ZonedDateTime defaultValidFrom = ZonedDateTime.now(timeZone).truncatedTo(ChronoUnit.DAYS);
            Iterator rowIterator = sheet.rowIterator();
            while (rowIterator.hasNext()) {
                ++numberOfInsertedCodes;
                Row row = (Row)rowIterator.next();
                BonDisRuleEntity disposableBonus = this.disposableBonusService.fromExelRow(row, (Collection)tariffs, defaultValidFrom);
                disposableBonus.setZone(zone);
                disposableBonus.setCreator(user);
                disposableBonus.setCreated(OffsetDateTime.now());
                this.disposableBonusService.persist(disposableBonus);
            }
        }
        catch (Exception e) {
            throw new ExcelProcessingException("Row " + numberOfInsertedCodes, (Throwable)e);
        }
        if (actionLogger.isInfoEnabled()) {
            actionLogger.info("The {} has uploaded {} bonus codes.", (Object)LoggerUtils.log((User)this.securityService.getCurrentUser()), (Object)numberOfInsertedCodes);
        }
        return new ResponseEntity((Object)new ExcelUploadResult(numberOfInsertedCodes, this.i18n.getLocalizedMessage("document.import.sucess", new Object[0])), (HttpStatusCode)HttpStatus.OK);
    }

    @PostMapping(value={"codes/list"})
    @PreAuthorize(value="hasRole('ROLE_PCON_BONUS_MANAGE')")
    @Transactional(readOnly=true)
    public DataTableResponse<BonDisUiBonus> list(@PathVariable(value="id") int zoneId, @RequestBody DataTableRequest dtRequest) {
        Zone zone = this.entityLoader.loadZone(zoneId);
        ZoneId userTimeZone = this.i18n.userTimeZoneId();
        Page data = StringUtils.isBlank((CharSequence)dtRequest.getSearch().getValue()) ? this.disposableBonusRepo.findByZone(zone, dtRequest.getPageable()) : this.disposableBonusRepo.findByZoneAndCodeContainingIgnoreCase(zone, dtRequest.getSearch().getValue(), dtRequest.getPageable());
        DataTableResponse response = new DataTableResponse();
        response.setDraw(dtRequest.getDraw());
        long totalElements = data.getTotalElements();
        response.setRecordsTotal(totalElements);
        response.setRecordsFiltered(totalElements);
        response.setData(data.stream().map(b -> new BonDisUiBonus(b, userTimeZone)).toList());
        return response;
    }
}

