/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.card_id;

import de.rtb.pcon.features.bonus.card_id.BonIdService;
import de.rtb.pcon.features.bonus.card_id.BonIdTypeDtoUi;
import de.rtb.pcon.features.bonus.card_id.BonIdTypeEntity;
import de.rtb.pcon.model.appmanagement.User;
import de.rtb.pcon.model.zone.Zone;
import de.rtb.pcon.ui.controllers.EntityNotAvailableException;
import de.rtb.pcon.ui.controllers.SecureEntityLoaderService;
import de.rtb.pcon.ui.services.I18nService;
import de.rtb.pcon.ui.services.SecurityService;
import de.rtb.pcon.ui.utils.controllers.excel.ExcelImportException;
import de.rtb.pcon.ui.utils.controllers.excel.ExcelProcessingException;
import de.rtb.pcon.ui.utils.controllers.excel.ExcelProcessingUtilsService;
import de.rtb.pcon.ui.utils.controllers.excel.ExcelUploadResult;
import de.rtb.pcontrol.utils.LoggerUtils;
import jakarta.persistence.PersistenceException;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.security.access.prepost.PreAuthorize;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(path={"/api/pcon/ui/zones/{zonId}/bonus/id/"})
@PreAuthorize(value="hasRole('ROLE_PCON_BONUS_MANAGE')")
class BonIdController {
    private static final Logger logger = LoggerFactory.getLogger(BonIdController.class);
    private static final Logger actionLogger = LoggerFactory.getLogger((String)"de.rtb.pcontrol.audit.actions.");
    @Autowired
    private SecurityService securityService;
    @Autowired
    private I18nService i18n;
    @Autowired
    private BonIdService bonusService;
    @Autowired
    private SecureEntityLoaderService entityLoader;
    @Autowired
    private ExcelProcessingUtilsService excelProcessingUtilsService;

    BonIdController() {
    }

    @ExceptionHandler(value={EntityNotAvailableException.class})
    public ResponseEntity<String> handleEntityLoadException(EntityNotAvailableException ex) {
        return new ResponseEntity((Object)ex.getMessage(), (HttpStatusCode)ex.getHttpStatus());
    }

    @ExceptionHandler(value={ExcelProcessingException.class})
    public ResponseEntity<ExcelUploadResult> handleExcelImportException(ExcelProcessingException exWrapper) {
        return this.excelProcessingUtilsService.handleExcelImportException(exWrapper);
    }

    @GetMapping(value={"types"})
    public List<BonIdTypeDtoUi> listTypes(@PathVariable(value="zonId") int zoneId) {
        Zone zone = this.entityLoader.loadZone(zoneId);
        return this.bonusService.listBonusTypes(zone);
    }

    @GetMapping(value={"types/{typeId}"})
    public BonIdTypeDtoUi getType(@PathVariable(value="zonId") int zoneId, @PathVariable(value="typeId") int typeId) {
        Zone zone = this.entityLoader.loadZone(zoneId);
        Optional cardTypeO = this.bonusService.findType(Integer.valueOf(typeId));
        if (cardTypeO.isEmpty() || !Objects.equals(zone, ((BonIdTypeEntity)cardTypeO.get()).getZone())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND);
        }
        return BonIdTypeDtoUi.fromEntity((BonIdTypeEntity)((BonIdTypeEntity)cardTypeO.get()));
    }

    @PutMapping(value={"types"})
    @Transactional
    public BonIdTypeDtoUi addType(@PathVariable(value="zonId") int zoneId, @RequestBody BonIdTypeDtoUi bonusCardType) {
        Zone zone = this.entityLoader.loadZone(zoneId);
        BonIdTypeEntity bonusTypeEntity = this.bonusService.createOrUpdateBonusType(bonusCardType, zone);
        return BonIdTypeDtoUi.fromEntity((BonIdTypeEntity)bonusTypeEntity);
    }

    @DeleteMapping(value={"types/{typeId}"})
    @Transactional
    public void deleteType(@PathVariable(value="zonId") int zoneId, @PathVariable(value="typeId") int typeId) {
        Zone zone = this.entityLoader.loadZone(zoneId);
        BonIdTypeEntity cardType = this.loadAndverifyTypeBonus(Integer.valueOf(typeId), zone);
        this.bonusService.deleteType(cardType);
    }

    @PostMapping(value={"rules/{typeId}"}, consumes={"multipart/form-data"})
    @Transactional
    public ResponseEntity<ExcelUploadResult> idSetRules(@PathVariable(value="zonId") int zoneId, @PathVariable(value="typeId") int typeId, @RequestParam(value="rules") MultipartFile file) {
        ResponseEntity responseEntity;
        block11: {
            Zone zone = this.entityLoader.loadZone(zoneId);
            logger.info("Uploaded data for 'ID card' bonus");
            Optional validationResult = this.excelProcessingUtilsService.validateEcxelUpload(file);
            if (validationResult.isPresent()) {
                return (ResponseEntity)validationResult.get();
            }
            BonIdTypeEntity cardType = this.loadAndverifyTypeBonus(Integer.valueOf(typeId), zone);
            User currentUser = this.securityService.getCurrentUser();
            logger.debug("Installing id card bonus rules from '{}'.", (Object)file.getOriginalFilename());
            int nrOfDeletedRules = this.bonusService.cleanBonusType(cardType);
            if (actionLogger.isInfoEnabled()) {
                actionLogger.info("The {} has deleted ID card bonus '{}' ({} entries).", new Object[]{LoggerUtils.log((User)currentUser), cardType.getName(), nrOfDeletedRules});
            }
            Workbook workbook = this.excelProcessingUtilsService.openWorkbookForStreaming(file);
            try {
                Sheet sheet = workbook.getSheetAt(0);
                int nrOfRules = this.bonusService.importExcelData(sheet, zone, cardType);
                if (actionLogger.isInfoEnabled()) {
                    actionLogger.info("The {} has inserted {} ID card bonus rules into bonus '{}'.", new Object[]{LoggerUtils.log((User)currentUser), nrOfRules, cardType.getName()});
                }
                responseEntity = new ResponseEntity((Object)new ExcelUploadResult(nrOfRules, this.i18n.getLocalizedMessage("document.import.sucess", new Object[0])), (HttpStatusCode)HttpStatus.OK);
                if (workbook == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (workbook != null) {
                        try {
                            workbook.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (ExcelImportException | PersistenceException | IOException e) {
                    throw new ExcelProcessingException(e);
                }
            }
            workbook.close();
        }
        return responseEntity;
    }

    BonIdTypeEntity loadAndverifyTypeBonus(Integer typeId, Zone zone) {
        Optional cardTypeEntO = this.bonusService.findType(typeId);
        if (cardTypeEntO.isEmpty() || !zone.equals((Object)((BonIdTypeEntity)cardTypeEntO.get()).getZone())) {
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.FORBIDDEN);
        }
        return (BonIdTypeEntity)cardTypeEntO.get();
    }
}

