/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.features.bonus.basic_1;

import de.rtb.pcon.core.real_time_request.RealTimeRequest;
import de.rtb.pcon.core.real_time_request.RealTimeRequestExecutionContext;
import de.rtb.pcon.features.bonus.AppliedBonusSource;
import de.rtb.pcon.features.bonus.BonusValue;
import de.rtb.pcon.features.bonus.CustomBonusValue;
import de.rtb.pcon.features.bonus.basic_1.BonBasic1RtrUsed;
import de.rtb.pcon.features.bonus.basic_1.BonBasic1Service;
import java.text.MessageFormat;
import java.time.Duration;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
class BonBasic1RtrUsed
implements RealTimeRequest {
    private static final Logger log = LoggerFactory.getLogger(BonBasic1RtrUsed.class);
    @Autowired
    private BonBasic1Service commonBonsuService;

    BonBasic1RtrUsed() {
    }

    public int getId() {
        return 17;
    }

    public String getDescription() {
        return "LPN basic bonus 1, consume";
    }

    public Map<String, Object> execute(RealTimeRequestExecutionContext ctx) {
        Optional<AppliedBonusSource> bapO = ctx.getLocalIntegerO("BAP").map(AppliedBonusSource::fromValue);
        Duration tap = ctx.getLocalIntegerO("TAP").map(Duration::ofMinutes).orElseThrow();
        String lcn = ctx.getLicensePlate();
        if (tap.isZero()) {
            log.info("Request failed, bonus duration must be greater then 0.");
            return Map.of();
        }
        if (StringUtils.isBlank((CharSequence)lcn)) {
            log.info("Request failed. Value of LPN is not present.");
            return Map.of("ERC", 4, "ERM", "License plate number (LPN) must be provided.");
        }
        if (bapO.isEmpty()) {
            log.info("Request failed. Value of BAP is not present.");
            return Map.of("ERC", 4, "ERM", "Bonus source (BAP) must be provided.");
        }
        AppliedBonusSource bap = bapO.get();
        return switch (1.$SwitchMap$de$rtb$pcon$features$bonus$AppliedBonusSource[bap.ordinal()]) {
            case 1 -> {
                this.commonBonsuService.recordUsage(ctx.findPayment());
                yield Map.of();
            }
            case 2 -> {
                CustomBonusValue bonus = new CustomBonusValue(tap);
                this.commonBonsuService.recordUsage(ctx.findPayment(), (BonusValue)bonus, AppliedBonusSource.DEBT);
                yield Map.of();
            }
            default -> {
                log.info("Request failed. Value of BAP '{}' must to be either 'SERVER' or 'DEBTH'.", (Object)bap);
                String erm = MessageFormat.format("Value of BAP ''{0}'' must to be either ''{1}'' or ''{2}''.", bap.ordinal(), AppliedBonusSource.SERVER.ordinal(), AppliedBonusSource.DEBT.ordinal());
                yield Map.of("ERC", 4, "ERM", erm);
            }
        };
    }
}

