/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.db.converter;

import jakarta.persistence.AttributeConverter;
import jakarta.persistence.Converter;
import java.sql.Date;
import java.time.LocalDate;
import java.time.YearMonth;

@Converter(autoApply=true)
public class YearMonthConverter
implements AttributeConverter<YearMonth, Date> {
    public Date convertToDatabaseColumn(YearMonth attribute) {
        if (attribute == null) {
            return null;
        }
        LocalDate date = LocalDate.of(attribute.getYear(), attribute.getMonth(), 1);
        return Date.valueOf(date);
    }

    public YearMonth convertToEntityAttribute(Date dbData) {
        if (dbData == null) {
            return null;
        }
        LocalDate date = dbData.toLocalDate();
        return YearMonth.of(date.getYear(), date.getMonth());
    }
}

