/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.user_data;

import de.rtb.pcon.core.user_data.TransferStatus;
import de.rtb.pcon.core.user_data.UserDataFileEntity;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.Optional;

/*
 * Exception performing whole class analysis ignored.
 */
class UiUserDataFile {
    private final Integer id;
    private final String name;
    private final Integer size;
    private final Integer sizeAnnounced;
    private final Integer status;
    private final Boolean aborted;
    private final Optional<LocalDateTime> created;
    private final Optional<Double> progress;
    private final Optional<Double> speed;

    public UiUserDataFile(UserDataFileEntity data, ZoneId timeZone) {
        boolean complete;
        this.id = data.getId();
        this.name = data.getName();
        this.size = data.getSizeReceived();
        this.sizeAnnounced = data.getSizeAnounced();
        this.status = data.getTransferStatus().ordinal();
        boolean bl = complete = data.getTransferStatus() != TransferStatus.IN_PROGRESS;
        if (!complete) {
            long downloadDuration = Duration.between(data.getCreatedPdm(), OffsetDateTime.now()).toSeconds();
            this.progress = UiUserDataFile.calculateProgresss((UserDataFileEntity)data);
            this.speed = Optional.of(data.getSizeReceived().doubleValue() / (double)downloadDuration);
        } else {
            this.progress = Optional.empty();
            this.speed = Optional.empty();
        }
        this.created = Optional.ofNullable(data.getCreatedPdm()).or(() -> Optional.ofNullable(data.getCreatedSrv())).map(t -> t.toZonedDateTime().withZoneSameInstant(timeZone).toLocalDateTime());
        this.aborted = data.isCanceled();
    }

    private static Optional<Double> calculateProgresss(UserDataFileEntity data) {
        if (data.getSizeAnounced() != null) {
            return Optional.of(data.getSizeReceived().doubleValue() / (double)data.getSizeAnounced().intValue());
        }
        if (data.getPartsAnounced() != null) {
            return Optional.of(data.getPartsReceived().doubleValue() / (double)data.getPartsAnounced().intValue());
        }
        return Optional.empty();
    }

    public Integer getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Integer getSize() {
        return this.size;
    }

    public Integer getStatus() {
        return this.status;
    }

    public Boolean getAborted() {
        return this.aborted;
    }

    public Optional<LocalDateTime> getCreated() {
        return this.created;
    }

    public Optional<Double> getProgress() {
        return this.progress;
    }

    public Optional<Double> getSpeed() {
        return this.speed;
    }

    public Integer getSizeAnnounced() {
        return this.sizeAnnounced;
    }
}

