/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.services.pdm_in;

import de.rtb.pcon.core.integration.Crc16;
import de.rtb.pcon.model.download.SoftwareDescription;
import de.rtb.pcon.model.download.SoftwareItem;
import de.rtb.pcon.model.download.SoftwarePath;
import de.rtb.pcontrol.pdm.fw5parser.Pdm5FwProcessor;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.codec.digest.DigestUtils;
import org.hibernate.engine.jdbc.BlobProxy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SoftwareDataProvider {
    private static final Logger logger = LoggerFactory.getLogger(SoftwareDataProvider.class);
    public static final String DEFAULT_PATH = "";
    @PersistenceContext
    private EntityManager entityManager;

    @Transactional
    public void addData(SoftwareDescription swd, byte[] data) {
        this.addData(swd, data, DEFAULT_PATH);
    }

    @Transactional
    public void addData(SoftwareDescription swd, byte[] data, String path) {
        if (swd.getSoftwarePaths() != null && swd.getSoftwarePaths().stream().filter(swp -> swp.getPath().equals(path)).count() > 0L) {
            throw new IllegalStateException("Path '" + path + "' is not unique in SoftwareDescription id " + swd.getId() + ".");
        }
        String sha1 = DigestUtils.sha1Hex((byte[])data);
        List itemCandidates = this.entityManager.createQuery("from SoftwareItem where sha=:sha1").setParameter("sha1", (Object)sha1).getResultList();
        try {
            SoftwareItem swi = null;
            if (!itemCandidates.isEmpty()) {
                for (SoftwareItem softwareItem : itemCandidates) {
                    if (!Arrays.equals(data, softwareItem.getData().getBytes(1L, (int)softwareItem.getData().length()))) continue;
                    swi = softwareItem;
                    logger.debug("SoftwareItem with SHA1 '{}' already exist. Creating link to id {}", (Object)sha1, (Object)swi.getId());
                    break;
                }
            }
            if (swi == null) {
                swi = new SoftwareItem();
                swi.setCrc(Crc16.calculateCrcString((byte[])data));
                swi.setSha(sha1);
                swi.setLength(data.length);
                swi.setCompressed(false);
                swi.setData(BlobProxy.generateProxy((byte[])data));
                this.entityManager.persist((Object)swi);
            }
            SoftwarePath softwarePath = new SoftwarePath();
            softwarePath.setSoftwareDescription(swd);
            softwarePath.setSoftwareItem(swi);
            softwarePath.setPath(path);
            this.entityManager.persist((Object)softwarePath);
            this.entityManager.refresh((Object)swd);
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    @Transactional
    public void removeOrphansSoftwareItems() {
        List orphanSoftwareItemIds = this.entityManager.createQuery("SELECT swi.id FROM SoftwareItem swi LEFT JOIN swi.softwarePaths swp WHERE swp IS NULL").getResultList();
        if (!orphanSoftwareItemIds.isEmpty()) {
            this.entityManager.createQuery("DELETE FROM SoftwareItem WHERE id IN (:orphanIds)").setParameter("orphanIds", (Object)orphanSoftwareItemIds).executeUpdate();
            StringBuilder selectOidsSql = new StringBuilder();
            selectOidsSql.append("SELECT sws_data FROM control.software_item WHERE sws_id IN (");
            Iterator iterator = orphanSoftwareItemIds.iterator();
            while (iterator.hasNext()) {
                selectOidsSql.append(iterator.next());
                if (!iterator.hasNext()) continue;
                selectOidsSql.append(", ");
            }
            selectOidsSql.append(");");
            List oids = this.entityManager.createNativeQuery(selectOidsSql.toString()).getResultList();
            for (BigInteger oid : oids) {
                this.entityManager.createNativeQuery("select lo_unlink(" + oid.toString() + ");").getSingleResult();
            }
        }
    }

    @Transactional
    public byte[] getSoftwareDataArray(SoftwareDescription swd, String path, int offset, int length) {
        try {
            SoftwareItem swi = this.getSoftwareItem(swd, path);
            return swi.getData().getBytes(offset + 1, length);
        }
        catch (SQLException e) {
            throw new IllegalStateException(e);
        }
    }

    @Transactional
    public SoftwareItem getSoftwareItem(SoftwareDescription swd, String path) {
        List swItems = this.entityManager.createQuery("select swp.softwareItem \nfrom SoftwareDescription swd \njoin swd.softwarePaths swp join swp.softwareDescription \nwhere swd = :swd and swp.path = :path").setParameter("swd", (Object)swd).setParameter("path", (Object)path).getResultList();
        if (swItems.size() == 1) {
            return (SoftwareItem)swItems.get(0);
        }
        if (swItems.isEmpty()) {
            throw new IllegalStateException("Path '" + path + "' doesn't exist in SoftwareDescription id " + swd.getId() + ".");
        }
        throw new IllegalStateException("There are " + swItems.size() + " paths '" + path + "' in SoftwareDescription id " + swd.getId() + ".");
    }

    public String addPdm5FwSoftwareItems(SoftwareDescription swd, InputStream pdm5FwInputStream) throws IOException {
        byte[] buffer = new byte[1024];
        String versionInfo = null;
        logger.debug("Extracting archive ... ");
        Pattern fwPartNamePattern = Pattern.compile("^pp0_([12])\\.h66$");
        ZipInputStream zis = new ZipInputStream(pdm5FwInputStream);
        ZipEntry ze = zis.getNextEntry();
        while (ze != null) {
            Matcher fwPartNameMatcher = fwPartNamePattern.matcher(ze.getName());
            if (fwPartNameMatcher.matches()) {
                int len;
                String itemName = fwPartNameMatcher.group(1);
                logger.debug("Extracting item '{}' (part {}) ({}B -> {}B).", new Object[]{ze.getName(), itemName, ze.getCompressedSize(), ze.getSize()});
                ByteArrayOutputStream txtFwBytes = new ByteArrayOutputStream((int)ze.getSize());
                while ((len = zis.read(buffer)) > 0) {
                    txtFwBytes.write(buffer, 0, len);
                }
                txtFwBytes.close();
                InputStreamReader txtFwReader = new InputStreamReader((InputStream)new ByteArrayInputStream(txtFwBytes.toByteArray()), StandardCharsets.ISO_8859_1);
                ByteArrayOutputStream binFwBytes = new ByteArrayOutputStream((int)ze.getSize());
                Pdm5FwProcessor pdm5p = new Pdm5FwProcessor();
                pdm5p.convert((Reader)txtFwReader, (OutputStream)binFwBytes);
                logger.debug("Firmware converted [{}] {} B, CRC {}", new Object[]{pdm5p.getInfo(), binFwBytes.size(), pdm5p.getCrc()});
                String thisVersionInfo = pdm5p.getInfo().getType() + pdm5p.getInfo().getVersionString();
                if (versionInfo == null) {
                    versionInfo = thisVersionInfo;
                } else if (!thisVersionInfo.equals(versionInfo)) {
                    throw new IllegalStateException("Version info doesn't match. Expected '" + versionInfo + "', got '" + thisVersionInfo + "'.");
                }
                this.addData(swd, binFwBytes.toByteArray(), itemName);
            } else {
                logger.debug("Skipping item '{}'.", (Object)ze.getName());
            }
            ze = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
        return versionInfo;
    }

    @Transactional
    public void addConfigBundle(SoftwareDescription swd, InputStream inputDataStream) throws IOException {
        byte[] buffer = new byte[1024];
        logger.debug("Extracting archive ... ");
        ZipInputStream zis = new ZipInputStream(inputDataStream);
        ZipEntry ze = zis.getNextEntry();
        int maxConfigSize = 5000;
        while (ze != null) {
            if (!ze.isDirectory()) {
                int len;
                String[] configName = ze.getName().split("[/\\.]");
                int area = Integer.parseInt(configName[0]);
                int pdm = Integer.parseInt(configName[1]);
                logger.debug("Adding configuration of PDM {}/{} ({} kB -> {} kB).", new Object[]{area, pdm, ze.getCompressedSize() / 1024L, ze.getSize() / 1024L});
                ByteArrayOutputStream baConfig = ze.getSize() > 0L ? new ByteArrayOutputStream((int)ze.getSize()) : new ByteArrayOutputStream(maxConfigSize);
                while ((len = zis.read(buffer)) > 0) {
                    baConfig.write(buffer, 0, len);
                }
                baConfig.close();
                this.addData(swd, baConfig.toByteArray(), String.format("%d/%d", area, pdm));
                maxConfigSize = Math.max(maxConfigSize, baConfig.size());
            }
            ze = zis.getNextEntry();
        }
        zis.closeEntry();
        zis.close();
    }
}

