/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.services.pdm_in;

import de.rtb.pcon.core.integration.PdmMessageRawDto;
import de.rtb.pcon.core.pdm.msg.json.device_report.DeviceReport;
import de.rtb.pcon.core.real_time_parking.RealTimeParkingService;
import de.rtb.pcon.core.services.pdm_in.ExtensiblePermitDbId;
import de.rtb.pcon.core.services.pdm_in.MessageParserHelper;
import de.rtb.pcon.model.PaymentCardType;
import de.rtb.pcon.model.PaymentReason;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcon.model.PaymentType;
import de.rtb.pcon.model.PaymentUserType;
import de.rtb.pcon.model.Pdm;
import java.math.BigDecimal;
import java.time.Duration;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;

public final class PdmMessageDto {
    private final Pdm pdm;
    private final ZoneId timeZone;
    private final OffsetDateTime datTim;
    private final OffsetDateTime createdAt = OffsetDateTime.now();
    private final String dbg;
    private final Integer trc;
    private final Integer csq;
    private final DeviceReport rdh;
    private final String rdm;
    private final String sdl;
    private String cpf;
    private final Short mnr;
    private final String iie;
    private final Integer uty;
    private final String tsi;
    private final String ppr;
    private final Integer cmd;
    private final Integer dpa;
    private final PaymentReason stp;
    private final PaymentType bza;
    private final PaymentUserType ust;
    private final BigDecimal bet;
    private final Integer tin;
    private final String zid;
    private final String wkz;
    private final OffsetDateTime parkEnd;
    private final PaymentCardType typ;
    private final Integer pan;
    private final String ath;
    private final String trf;
    private final Integer ske;
    private final String lcn;
    private final Integer tid;
    private final Optional<ExtensiblePermitDbId> eid;
    private final BigDecimal bep;
    private final String pti;
    private final Integer abn;
    private final Integer abt;
    private final String ait;
    private final String cch;
    private final Integer akt;
    private final Integer ant;
    private final Integer asn;
    private final BigDecimal aub;
    private final BigDecimal auf;
    private final BigDecimal bin;
    private final BigDecimal bta;
    private final BigDecimal btb;
    private final BigDecimal btc;
    private final BigDecimal btd;
    private final BigDecimal bte;
    private final BigDecimal btf;
    private final BigDecimal btg;
    private final BigDecimal bth;
    private final boolean est;
    private final BigDecimal tob;
    private final BigDecimal ton;
    private final BigDecimal tok;
    private final BigDecimal kin;
    private final BigDecimal kvk;
    private final Float acu;
    private final Duration kai;
    private final Integer fsa;
    private final Integer fsi;
    private final String fml;
    private final String fdl;
    private final Integer dlt;
    private final String fxl;
    private final String app;
    private final String fmd;
    private final String fdd;
    private final String fxd;
    private final String mdl;
    private final String ver;
    private final String pid;
    private final String vem;
    private final String vep;
    private final String arv;
    private final String veh;
    private final String spc;
    private final Integer req;
    private final Integer snr;
    private final List<Map<String, Object>> mrq;
    private PaymentTransaction payment = null;

    public PdmMessageDto(Pdm pdm, PdmMessageRawDto m, MessageParserHelper s) {
        this.pdm = pdm;
        this.timeZone = ZoneId.of(pdm.getZone().getArea().getTimeZoneName());
        this.datTim = MessageParserHelper.parsePdmDateTime((String)m.dtm(), (String)m.dat(), (String)m.tim(), (ZoneId)this.timeZone);
        this.acu = MessageParserHelper.parseScaledFloat((Integer)m.acu(), (int)1);
        this.dbg = m.dbg();
        this.csq = m.csq();
        this.trc = m.trc();
        this.ppr = m.ppr();
        this.dpa = m.dpa();
        this.rdh = s.parseDeviceHourlyReport(m.rdh());
        this.rdm = m.rdm();
        this.sdl = m.sdl();
        this.cpf = m.cpf();
        this.mnr = s.parseStatusNumber(m.mnr());
        this.iie = s.parseStatusReason(m.iie());
        this.uty = m.uty();
        this.tsi = m.tsi();
        this.cmd = m.cmd();
        this.stp = PaymentReason.fromValue((Integer)m.stp());
        this.bza = PaymentType.fromValue((Integer)m.bza());
        this.ust = PaymentUserType.fromValue((Integer)m.ust());
        BigDecimal betTmp = MessageParserHelper.toBigDecimal((Integer)m.bet(), (Integer)m.dpa());
        if (StringUtils.isBlank((CharSequence)m.pti()) && RealTimeParkingService.RTP_END_REASNOS.contains(this.stp)) {
            betTmp = betTmp.negate();
        }
        this.bet = betTmp;
        this.tin = m.tin();
        this.zid = MessageParserHelper.parseCardNumber((String)m.zid());
        this.wkz = m.wkz();
        this.parkEnd = MessageParserHelper.parsePdmDateTime(null, (String)m.ped(), (String)m.pet(), (ZoneId)this.timeZone);
        this.typ = PaymentCardType.fromValue((Integer)m.typ());
        this.pan = s.unifyParkingSpaceNumber(m.pan());
        this.ath = MessageParserHelper.trimText((String)m.ath());
        this.trf = MessageParserHelper.trimText((String)m.trf());
        this.ske = MessageParserHelper.parseIntHex((String)m.ske());
        this.lcn = MessageParserHelper.parseLcn((String)m.lcn());
        this.tid = m.tid();
        this.eid = Optional.ofNullable(m.eid()).map(ExtensiblePermitDbId::new);
        this.bep = MessageParserHelper.toBigDecimal((Integer)m.bep(), (Integer)m.dpa());
        this.pti = MessageParserHelper.trimText((String)m.pti());
        this.abn = m.abn();
        this.ton = MessageParserHelper.toBigDecimal((Integer)m.ton(), (Integer)m.dpa());
        this.tob = MessageParserHelper.toBigDecimal((Integer)m.tob(), (Integer)m.dpa());
        this.tok = MessageParserHelper.toBigDecimal((Integer)m.tok(), (Integer)m.dpa());
        this.bta = MessageParserHelper.toBigDecimal((Integer)m.bta(), (Integer)m.dpa());
        this.btb = MessageParserHelper.toBigDecimal((Integer)m.btb(), (Integer)m.dpa());
        this.btc = MessageParserHelper.toBigDecimal((Integer)m.btc(), (Integer)m.dpa());
        this.btd = MessageParserHelper.toBigDecimal((Integer)m.btd(), (Integer)m.dpa());
        this.bte = MessageParserHelper.toBigDecimal((Integer)m.bte(), (Integer)m.dpa());
        this.btf = MessageParserHelper.toBigDecimal((Integer)m.btf(), (Integer)m.dpa());
        this.btg = MessageParserHelper.toBigDecimal((Integer)m.btg(), (Integer)m.dpa());
        this.bth = MessageParserHelper.toBigDecimal((Integer)m.bth(), (Integer)m.dpa());
        this.auf = MessageParserHelper.toBigDecimal((Integer)m.auf(), (Integer)m.dpa());
        this.bin = MessageParserHelper.toBigDecimal((Integer)m.bin(), (Integer)m.dpa());
        this.kin = MessageParserHelper.toBigDecimal((Integer)m.kin(), (Integer)m.dpa());
        this.aub = MessageParserHelper.toBigDecimal((Integer)m.aub(), (Integer)m.dpa());
        this.kvk = MessageParserHelper.toBigDecimal((Integer)m.kvk(), (Integer)m.dpa());
        this.abt = Objects.requireNonNullElse(m.abt(), NumberUtils.INTEGER_ZERO);
        this.ant = Objects.requireNonNullElse(m.ant(), NumberUtils.INTEGER_ZERO);
        this.akt = Objects.requireNonNullElse(m.akt(), NumberUtils.INTEGER_ZERO);
        this.asn = m.asn();
        this.est = m.est() != null;
        this.ait = m.ait();
        this.cch = m.cch();
        this.kai = MessageParserHelper.durationFromMinutes((Integer)m.kai());
        this.fsa = m.fsa();
        this.fsi = m.fsi();
        this.fml = m.fml();
        this.fdl = m.fdl();
        this.dlt = m.dlt();
        this.fxl = m.fxl();
        this.app = m.app();
        this.fmd = m.fmd();
        this.fdd = m.fdd();
        this.fxd = m.fxd();
        this.mdl = m.mdl();
        this.ver = StringUtils.trim((String)m.ver());
        this.pid = m.pid();
        this.vem = m.vem();
        this.vep = m.vep();
        this.arv = m.arv();
        this.veh = m.veh();
        this.spc = m.spc();
        this.snr = m.snr();
        this.req = m.req();
        this.mrq = s.parseRealTimeMultiRequest(m.mrq());
    }

    public PaymentTransaction getPayment() {
        return this.payment;
    }

    public void setPayment(PaymentTransaction payment) {
        this.payment = payment;
    }

    public void clearCpf() {
        this.cpf = null;
    }

    public OffsetDateTime getCreatedAt() {
        return this.createdAt;
    }

    public Pdm getPdm() {
        return this.pdm;
    }

    public ZoneId getTimeZone() {
        return this.timeZone;
    }

    public OffsetDateTime getDatTim() {
        return this.datTim;
    }

    public String getDbg() {
        return this.dbg;
    }

    public Integer getTrc() {
        return this.trc;
    }

    public Integer getCsq() {
        return this.csq;
    }

    public DeviceReport getRdh() {
        return this.rdh;
    }

    public String getRdm() {
        return this.rdm;
    }

    public String getMdl() {
        return this.mdl;
    }

    public String getSdl() {
        return this.sdl;
    }

    public String getCpf() {
        return this.cpf;
    }

    public Short getMnr() {
        return this.mnr;
    }

    public Integer getUty() {
        return this.uty;
    }

    public String getTsi() {
        return this.tsi;
    }

    public String getIie() {
        return this.iie;
    }

    public String getPpr() {
        return this.ppr;
    }

    public Integer getCmd() {
        return this.cmd;
    }

    public Integer getDpa() {
        return this.dpa;
    }

    public PaymentReason getStp() {
        return this.stp;
    }

    public PaymentType getBza() {
        return this.bza;
    }

    public PaymentUserType getUst() {
        return this.ust;
    }

    public BigDecimal getBet() {
        return this.bet;
    }

    public Integer getTin() {
        return this.tin;
    }

    public String getZid() {
        return this.zid;
    }

    public String getWkz() {
        return this.wkz;
    }

    public OffsetDateTime getParkEnd() {
        return this.parkEnd;
    }

    public PaymentCardType getTyp() {
        return this.typ;
    }

    public Integer getPan() {
        return this.pan;
    }

    public String getAth() {
        return this.ath;
    }

    public String getTrf() {
        return this.trf;
    }

    public Integer getSke() {
        return this.ske;
    }

    public String getLcn() {
        return this.lcn;
    }

    public Integer getTid() {
        return this.tid;
    }

    public Optional<ExtensiblePermitDbId> getEid() {
        return this.eid;
    }

    public BigDecimal getBep() {
        return this.bep;
    }

    public String getPti() {
        return this.pti;
    }

    public Integer getAbn() {
        return this.abn;
    }

    public Integer getAbt() {
        return this.abt;
    }

    public String getAit() {
        return this.ait;
    }

    public String getCch() {
        return this.cch;
    }

    public Integer getAkt() {
        return this.akt;
    }

    public Integer getAnt() {
        return this.ant;
    }

    public Integer getAsn() {
        return this.asn;
    }

    public BigDecimal getAub() {
        return this.aub;
    }

    public BigDecimal getAuf() {
        return this.auf;
    }

    public BigDecimal getBin() {
        return this.bin;
    }

    public BigDecimal getBta() {
        return this.bta;
    }

    public BigDecimal getBtb() {
        return this.btb;
    }

    public BigDecimal getBtc() {
        return this.btc;
    }

    public BigDecimal getBtd() {
        return this.btd;
    }

    public BigDecimal getBte() {
        return this.bte;
    }

    public BigDecimal getBtf() {
        return this.btf;
    }

    public BigDecimal getBtg() {
        return this.btg;
    }

    public BigDecimal getBth() {
        return this.bth;
    }

    public boolean isEst() {
        return this.est;
    }

    public BigDecimal getTob() {
        return this.tob;
    }

    public BigDecimal getTon() {
        return this.ton;
    }

    public BigDecimal getTok() {
        return this.tok;
    }

    public BigDecimal getKin() {
        return this.kin;
    }

    public BigDecimal getKvk() {
        return this.kvk;
    }

    public Float getAcu() {
        return this.acu;
    }

    public Duration getKai() {
        return this.kai;
    }

    public Integer getFsa() {
        return this.fsa;
    }

    public Integer getFsi() {
        return this.fsi;
    }

    public String getFml() {
        return this.fml;
    }

    public String getFdl() {
        return this.fdl;
    }

    public Integer getDlt() {
        return this.dlt;
    }

    public String getFxl() {
        return this.fxl;
    }

    public String getApp() {
        return this.app;
    }

    public String getFmd() {
        return this.fmd;
    }

    public String getFdd() {
        return this.fdd;
    }

    public String getFxd() {
        return this.fxd;
    }

    public List<Map<String, Object>> getRealTimeRequests() {
        return this.mrq;
    }

    public String getVer() {
        return this.ver;
    }

    public String getPid() {
        return this.pid;
    }

    public String getVem() {
        return this.vem;
    }

    public String getVep() {
        return this.vep;
    }

    public String getArv() {
        return this.arv;
    }

    public String getVeh() {
        return this.veh;
    }

    public String getSpc() {
        return this.spc;
    }

    public Integer getReq() {
        return this.req;
    }

    public Integer getSnr() {
        return this.snr;
    }
}

