/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.runtime_monitor;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rtb.pcon.core.pdm.msg.json.SmTariffInfo;
import de.rtb.pcon.core.services.pdm_in.PdmMessageDto;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.TariffInfo;
import de.rtb.pcon.repositories.TariffInfoRepository;
import java.io.IOException;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class TariffService {
    private static final Logger log = LoggerFactory.getLogger(TariffService.class);
    @Autowired
    private TariffInfoRepository tariffInfoDao;
    @Autowired
    @Qualifier(value="pdmObjectMapper")
    ObjectMapper pdmObjectMapper;

    @Transactional
    public void processTariffReport(PdmMessageDto m) {
        if (m.getTsi() != null) {
            log.debug("~ Tariff info");
            List tariffInfo = this.parseTariffInfo(m.getTsi());
            if (!tariffInfo.isEmpty()) {
                this.storeTariffInfo(m.getPdm(), tariffInfo);
            }
        }
    }

    List<SmTariffInfo> parseTariffInfo(String tariffInfoJson) {
        if (tariffInfoJson != null) {
            try {
                return (List)this.pdmObjectMapper.readValue(tariffInfoJson, (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            }
            catch (IllegalArgumentException e) {
                log.error("Cannot decode tariff names", (Throwable)e);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return List.of();
    }

    private void storeTariffInfo(Pdm pdm, List<SmTariffInfo> tsi) {
        LinkedList<TariffInfo> dbTi = pdm.getTariffInfos();
        if (dbTi == null) {
            dbTi = new LinkedList<TariffInfo>();
        }
        boolean tariffInfoUpdateRequired = false;
        if (tsi.size() == dbTi.size()) {
            tariffInfoUpdateRequired = false;
            for (int i = 0; i < dbTi.size(); ++i) {
                if (((TariffInfo)dbTi.get(i)).getName().equals(tsi.get(i).getName())) continue;
                tariffInfoUpdateRequired = true;
                break;
            }
        } else {
            tariffInfoUpdateRequired = true;
        }
        if (tariffInfoUpdateRequired) {
            dbTi.clear();
            Set usedTariffNames = tsi.stream().map(SmTariffInfo::getName).collect(Collectors.toSet());
            List availableTariffInfosInDb = this.tariffInfoDao.findByNameIn(usedTariffNames);
            for (SmTariffInfo tiMsg : tsi) {
                Optional<TariffInfo> tiDbOpt = availableTariffInfosInDb.stream().filter(t -> t.getName().equals(tiMsg.getName())).findFirst();
                if (tiDbOpt.isPresent()) {
                    dbTi.add(tiDbOpt.get());
                    continue;
                }
                TariffInfo tiNew = new TariffInfo();
                tiNew.setName(tiMsg.getName());
                tiNew.setVisible(tiMsg.isVisible());
                tiNew.setEpos(tiMsg.isEpos());
                this.tariffInfoDao.save((Object)tiNew);
                dbTi.add(tiNew);
                log.info("Created new tariff info '{}'.", (Object)tiNew.getName());
                availableTariffInfosInDb.add(tiNew);
            }
        }
    }

    public static TariffInfo findTariffInfo(Pdm pdm, Integer tid) {
        if (tid == null || CollectionUtils.isEmpty((Collection)pdm.getTariffInfos())) {
            return null;
        }
        int tariffIndex = tid - 1;
        List tariffs = pdm.getTariffInfos();
        if (pdm.getTariffInfos().size() > tariffIndex) {
            return (TariffInfo)tariffs.get(tariffIndex);
        }
        log.info("Tariff with index {} doesn't exist.", (Object)tariffIndex);
        return null;
    }
}

