/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.real_time_parking;

import de.rtb.pcon.model.PaymentReason;
import de.rtb.pcon.model.PaymentTransaction;
import de.rtb.pcon.model.RtpSession;
import de.rtb.pcon.repositories.RtpSessionRepository;
import java.math.BigDecimal;
import java.util.EnumSet;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class RealTimeParkingService {
    public static final Logger log = LoggerFactory.getLogger(RealTimeParkingService.class);
    public static final Set<PaymentReason> RTP_START_REASNOS = EnumSet.of(PaymentReason.RTP_LOGON);
    public static final Set<PaymentReason> RTP_END_REASNOS = EnumSet.of(PaymentReason.RTP_LOGOFF, PaymentReason.RTP_FORCED_LOGOFF, PaymentReason.RTP_EXTRINSIC_LOGOFF);
    @Autowired
    private RtpSessionRepository rtpSessionRepo;

    @Transactional(noRollbackFor={NoSuchElementException.class})
    public void registerRtp(PaymentTransaction payment, String sessionName) {
        if (StringUtils.isBlank((CharSequence)sessionName)) {
            log.error("RTP session name has to be provided !");
            return;
        }
        String fullSessionName = payment.getLpn() + ":" + sessionName;
        RtpSession rtpSession = this.rtpSessionRepo.findByName(fullSessionName).orElseGet(() -> {
            RtpSession s = new RtpSession(fullSessionName);
            this.rtpSessionRepo.save((Object)s);
            return s;
        });
        List sessionPayments = rtpSession.getPayments();
        if (sessionPayments.isEmpty()) {
            payment.setRtpSession(rtpSession);
        } else if (sessionPayments.size() == 1) {
            PaymentTransaction payment2 = (PaymentTransaction)sessionPayments.get(0);
            if (RTP_START_REASNOS.contains(payment.getPaymentReason()) && RTP_START_REASNOS.contains(payment2.getPaymentReason())) {
                log.error("Payment of type 'RTP_START' has been already received for this session '{}'. Ignoring RTP. ({}).", (Object)fullSessionName, (Object)payment2);
                return;
            }
            if (RTP_END_REASNOS.contains(payment.getPaymentReason()) && RTP_END_REASNOS.contains(payment2.getPaymentReason())) {
                log.error("Payment of type 'RTP_END' has been already received for this session '{}'. Ignoring RTP. ({}).", (Object)fullSessionName, (Object)payment2);
                return;
            }
            payment.setRtpSession(payment2.getRtpSession());
            Set<PaymentTransaction> rtpPaymets = Set.of(payment, payment2);
            PaymentTransaction logOn = rtpPaymets.stream().filter(p -> RTP_START_REASNOS.contains(p.getPaymentReason())).findAny().orElseThrow(() -> new NoSuchElementException("RTP log on payment not found"));
            PaymentTransaction logOff = rtpPaymets.stream().filter(p -> RTP_END_REASNOS.contains(p.getPaymentReason())).findAny().orElseThrow(() -> new NoSuchElementException("RTP log off payment not found"));
            logOn.setAmount(logOff.getAmount());
            logOff.setAmount(BigDecimal.ZERO);
            logOn.setParkEndTime(logOff.getParkEndTime());
            logOn.setPaymentReason(PaymentReason.RTP);
            rtpSession.setName(null);
        } else {
            String paymentStr = sessionPayments.stream().map(PaymentTransaction::toString).collect(Collectors.joining(", "));
            log.error("There are {} payments connected with RTP session #{} already ({}). It is not possible to assign this RTP.", new Object[]{sessionPayments.size(), sessionName, paymentStr});
        }
    }
}

