/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.open_messages;

import de.rtb.pcon.model.PdmStatus;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import jakarta.persistence.Tuple;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class OpenMessagesRepo {
    @PersistenceContext
    private EntityManager entityManager;

    @Transactional
    public List<Tuple> listOpenMessageTupples(Collection<Integer> pdmIds) {
        return this.entityManager.createQuery("SELECT s, mcd, mcu FROM PdmStatus s JOIN FETCH s.statusMessage JOIN FETCH s.pdm p JOIN FETCH p.zone z JOIN s.messageConfig mcd LEFT JOIN MessageConfigUser mcu ON mcu.number = mcd.number AND mcu.area = z.area WHERE p.id IN (:pdmIds)\n", Tuple.class).setParameter("pdmIds", pdmIds).getResultList();
    }

    @Transactional
    public Optional<PdmStatus> findOpenMessage(int pdmId, int msgNr) {
        List statusees = this.entityManager.createQuery("SELECT s\nFROM PdmStatus s\nJOIN s.pdm p\nJOIN s.messageConfig mcd\nLEFT JOIN MessageConfigUser mcu ON mcu.number = mcd.number AND mcu.area = p.area\nWHERE p.id = :pdmId)\n", PdmStatus.class).setParameter("pdmId", (Object)pdmId).setParameter("msgNr", (Object)msgNr).setMaxResults(1).getResultList();
        if (statusees.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of((PdmStatus)statusees.get(0));
    }

    @Transactional
    public void deleteOpenMessage(PdmStatus ps) {
        this.entityManager.remove((Object)ps);
    }
}

