/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.notification.sms;

import java.text.Normalizer;
import java.util.regex.Pattern;
import org.apache.commons.lang3.ArrayUtils;

/*
 * Exception performing whole class analysis ignored.
 */
public class SmsUtils {
    public static final Pattern DIACRITICS_AND_FRIENDS = Pattern.compile("[\\p{InCombiningDiacriticalMarks}\\p{IsLm}\\p{IsSk}]+");
    private static final char[] GSM7_ALLOWED_CHARACTERS = new char[]{'@', '\u0394', ' ', '0', '\u00a1', 'P', '\u00bf', 'p', '\u00a3', '_', '!', '1', 'A', 'Q', 'a', 'q', '$', '\u03a6', '\"', '2', 'B', 'R', 'b', 'r', '\u00a5', '\u0393', '#', '3', 'C', 'S', 'c', 's', '\u00e8', '\u039b', '\u00a4', '4', 'D', 'T', 'd', 't', '\u00e9', '\u03a9', '%', '5', 'E', 'U', 'e', 'u', '\u00f9', '\u03a0', '&', '6', 'F', 'V', 'f', 'v', '\u00ec', '\u03a8', '\'', '7', 'G', 'W', 'g', 'w', '\u00f2', '\u03a3', '(', '8', 'H', 'X', 'h', 'x', '\u00c7', '\u0398', ')', '9', 'I', 'Y', 'i', 'y', '\n', '\u039e', '*', ':', 'J', 'Z', 'j', 'z', '\u00d8', '\u001b', '+', ';', 'K', '\u00c4', 'k', '\u00e4', '\u00f8', '\u00c6', ',', '<', 'L', '\u00d6', 'l', '\u00f6', '\r', '\u00e6', '-', '=', 'M', '\u00d1', 'm', '\u00f1', '\u00c5', '\u00df', '.', '>', 'N', '\u00dc', 'n', '\u00fc', '\u00e5', '\u00c9', '/', '?', 'O', '\u00a7', 'o', '\u00e0', '|', '^', '\u20ac', '{', '}', '[', '~', ']', '\\'};

    private SmsUtils() {
    }

    public static final String toGsm(String text) {
        StringBuilder result = new StringBuilder();
        for (char c : text.toCharArray()) {
            if (ArrayUtils.indexOf((char[])GSM7_ALLOWED_CHARACTERS, (char)c) != -1) {
                result.append(c);
                continue;
            }
            String normalized = SmsUtils.normalize((String)String.valueOf(c));
            for (char c1 : normalized.toCharArray()) {
                if (ArrayUtils.indexOf((char[])GSM7_ALLOWED_CHARACTERS, (char)c1) != -1) {
                    result.append(c1);
                    continue;
                }
                result.append('?');
            }
        }
        return result.toString();
    }

    private static final String normalize(String str) {
        str = Normalizer.normalize(str, Normalizer.Form.NFD);
        str = DIACRITICS_AND_FRIENDS.matcher(str).replaceAll("");
        return str;
    }
}

