/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.notification;

import de.rtb.pcon.core.notification.PriorityResourceLoader;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.core.io.Resource;
import org.springframework.http.HttpStatus;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;

@Controller
class MailWebResourcesController {
    @Autowired
    private PriorityResourceLoader resourceLoader;

    MailWebResourcesController() {
    }

    @GetMapping(value={"/res/notification/{resourceName}"})
    public void mailResourceProviderEndpoint(HttpServletRequest request, HttpServletResponse response, @PathVariable String resourceName) throws IOException {
        Resource resource = this.resourceLoader.getResource(resourceName);
        if (resource.exists()) {
            response.setContentLength((int)resource.contentLength());
            response.setContentType(request.getServletContext().getMimeType(resource.getFilename()));
            IOUtils.copy((InputStream)resource.getInputStream(), (OutputStream)response.getOutputStream());
        } else {
            response.setStatus(HttpStatus.NOT_FOUND.value());
        }
    }
}

