/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.look_up.status_filters;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.rtb.pcon.core.look_up.status_filters.CacheStatusFiltersDto;
import de.rtb.pcon.core.look_up.status_filters.StatusFilterLookupDto;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.RowMapper;

class CacheStatusFilterRowMapper
implements RowMapper<CacheStatusFiltersDto> {
    private static final Logger log = LoggerFactory.getLogger(CacheStatusFilterRowMapper.class);
    private ObjectMapper objectMapper;

    public CacheStatusFilterRowMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
    }

    public CacheStatusFiltersDto mapRow(ResultSet rs, int rowNum) throws SQLException {
        Integer id = rs.getInt(1);
        String json = rs.getString(2);
        Long lastUsedId = rs.getLong(3);
        CacheStatusFiltersDto result = new CacheStatusFiltersDto();
        result.setId(id);
        result.setLastUsedId(lastUsedId);
        try {
            List cache = (List)this.objectMapper.readValue(json, (JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, StatusFilterLookupDto.class));
            result.setAreas(cache);
        }
        catch (JsonProcessingException e) {
            log.error("Cannot parse cached value '" + json + "'", (Throwable)e);
        }
        return result;
    }
}

