/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.integration;

import de.rtb.pcon.core.integration.IntegrationConfig;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessageChannel;

class UpdMessageTask
implements Runnable {
    private static final Logger log = LoggerFactory.getLogger(UpdMessageTask.class);
    private byte[] dataFromPdm;
    private InetAddress srcAddress;
    private int srcPort;
    private IntegrationConfig.UdpInGateway gateway;
    private MessageChannel replyChannel;
    private MessageChannel errorChannel;

    public UpdMessageTask(byte[] data, InetAddress srcAddress, int srcPort, IntegrationConfig.UdpInGateway gateway, MessageChannel replyChannel, MessageChannel errorChannel) {
        this.dataFromPdm = data;
        this.srcAddress = srcAddress;
        this.srcPort = srcPort;
        this.gateway = gateway;
        this.replyChannel = replyChannel;
        this.errorChannel = errorChannel;
    }

    @Override
    public void run() {
        int payloadStart = ArrayUtils.indexOf((byte[])this.dataFromPdm, (byte)1);
        int payloadEnd = ArrayUtils.indexOf((byte[])this.dataFromPdm, (byte)3);
        if (payloadStart != -1 && payloadEnd != -1) {
            this.dataFromPdm = ArrayUtils.subarray((byte[])this.dataFromPdm, (int)payloadStart, (int)(payloadEnd + 1));
        }
        if (this.dataFromPdm.length > 1 && this.dataFromPdm[0] == 1 && this.dataFromPdm[this.dataFromPdm.length - 1] == 3) {
            byte[] deserializedData = Arrays.copyOfRange(this.dataFromPdm, 1, this.dataFromPdm.length - 1);
            Message springMessage = ((MessageBuilder)((MessageBuilder)((MessageBuilder)((MessageBuilder)MessageBuilder.withPayload((Object)deserializedData).setHeader("ip_address", (Object)this.srcAddress.getHostAddress())).setHeader("ip_port", (Object)this.srcPort)).setErrorChannel(this.errorChannel)).setReplyChannel(this.replyChannel)).build();
            this.gateway.send(springMessage);
        } else if (log.isWarnEnabled()) {
            String msg = new String(this.dataFromPdm, StandardCharsets.ISO_8859_1);
            log.warn("Ignoring incorrect message '{}' from {}:{}.", new Object[]{msg, this.srcAddress, this.srcPort});
        }
    }
}

