/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.integration;

import de.rtb.pcon.core.integration.MessageFunctions;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.springframework.core.NestedRuntimeException;

public class PdmMessageProcessionException
extends NestedRuntimeException {
    private final Optional<Map<String, String>> responseMap;
    private final Optional<Integer> errorCode;
    private final Optional<String> errorText = Optional.empty();

    public PdmMessageProcessionException(String msg) {
        super(msg);
        this.errorCode = Optional.empty();
        this.responseMap = Optional.empty();
    }

    public PdmMessageProcessionException(Throwable cause) {
        super("Wrapped exception", cause);
        this.errorCode = Optional.empty();
        this.responseMap = Optional.empty();
    }

    public PdmMessageProcessionException(String msg, Throwable cause) {
        super(msg, cause);
        this.errorCode = Optional.empty();
        this.responseMap = Optional.empty();
    }

    public PdmMessageProcessionException(String msg, Throwable cause, Map<String, String> responseMap) {
        super(msg, cause);
        this.errorCode = Optional.empty();
        this.responseMap = Optional.of(responseMap);
    }

    public Map<String, String> getResponseMap() {
        return this.responseMap.orElseGet(() -> this.createDefaulResponseMap());
    }

    private Map<String, String> createDefaulResponseMap() {
        HashMap<String, String> respMap = new HashMap<String, String>();
        String errorTextForPdm = this.errorText.or(() -> Optional.ofNullable(this.getMostSpecificCause().getMessage())).map(MessageFunctions::formatErrorMessageForPdmMnemonic).orElse("");
        respMap.put("ERM", errorTextForPdm);
        this.errorCode.map(Objects::toString).ifPresent(s -> respMap.put("ERC", (String)s));
        return respMap;
    }
}

