/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.integration;

import de.rtb.pcon.core.integration.Crc16;
import de.rtb.pcon.core.integration.IntegrationConsts;
import de.rtb.pcon.core.logging.PdmThreadLocalMarker;
import de.rtb.pcontrol.utils.PdmTextEncoder;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.integration.annotation.Transformer;
import org.springframework.integration.support.MessageBuilder;
import org.springframework.messaging.Message;

/*
 * Exception performing whole class analysis ignored.
 */
final class MessageFunctions {
    private static final Logger log = LoggerFactory.getLogger(MessageFunctions.class);

    private MessageFunctions() {
    }

    public static final boolean verifyCrc(byte[] input) {
        String gotCrc;
        int crcMnemonicLength = Math.min(7, input.length);
        String crcMnemonic = new String(input, input.length - crcMnemonicLength, crcMnemonicLength, StandardCharsets.ISO_8859_1);
        String crcMnemonicName = StringUtils.substring((String)crcMnemonic, (int)0, (int)3);
        String crcMnemonicValue = StringUtils.substring((String)crcMnemonic, (int)3);
        if (!"CRC".equals(crcMnemonicName)) {
            log.error("Message does not contain CRC");
            return false;
        }
        byte[] msgBytes = ArrayUtils.subarray((byte[])input, (int)0, (int)(input.length - 7));
        String expectedCrc = Crc16.calculateCrcString((byte[])msgBytes).toUpperCase();
        if (!StringUtils.equals((CharSequence)expectedCrc, (CharSequence)(gotCrc = StringUtils.upperCase((String)crcMnemonicValue, (Locale)Locale.ENGLISH)))) {
            log.error("Message has invalid CRC. Expected was {} but {} received.", (Object)expectedCrc, (Object)gotCrc);
            return false;
        }
        return true;
    }

    @Transformer
    public static final Message<Map<String, String>> byteArrayToMap(Message<byte[]> message) {
        MessageFunctions.clearThreadMetaData();
        String msgText = (String)message.getHeaders().get((Object)"reqText", String.class);
        Map mnemonicMap = MessageFunctions.mapMnemonics((String)msgText);
        Message outMsg = ((MessageBuilder)MessageBuilder.withPayload((Object)mnemonicMap).copyHeaders((Map)message.getHeaders())).build();
        MessageFunctions.setThreadMetaData((Message)outMsg);
        return outMsg;
    }

    static Map<String, String> mapMnemonics(String payload) {
        String[] msgData;
        HashMap<String, String> mnemonicMap = new HashMap<String, String>();
        for (String s : msgData = StringUtils.split((String)payload, (String)";")) {
            String key = StringUtils.substring((String)s, (int)0, (int)3).toUpperCase();
            String val = StringUtils.substring((String)s, (int)3);
            val = URLDecoder.decode(val, IntegrationConsts.PDM_MESSAGE_ENCODING);
            mnemonicMap.put(key, val);
        }
        return mnemonicMap;
    }

    public static String makeIncommingPacketLog(Message<?> msg) {
        String proto = Optional.ofNullable((String)msg.getHeaders().get((Object)"src_protocol", String.class)).map(String::toUpperCase).orElse("N/A");
        String addr = Optional.ofNullable((String)msg.getHeaders().get((Object)"ip_address", String.class)).orElse("N/A");
        String msgText = (String)msg.getHeaders().get((Object)"reqText", String.class);
        return ">>> [" + proto + ", " + addr + "]: " + msgText;
    }

    public static void setThreadMetaData(Message<Map<String, String>> msg) {
        Map mm = (Map)msg.getPayload();
        PdmThreadLocalMarker threadMarker = PdmThreadLocalMarker.instance();
        threadMarker.setPdm((String)mm.get("PSA"), (String)mm.get("GAC"), (String)mm.get("PID"));
        String addr = (String)msg.getHeaders().get((Object)"ip_address", String.class);
        Integer port = Optional.ofNullable((Integer)msg.getHeaders().get((Object)"ip_port", Integer.class)).orElse(-1);
        threadMarker.setNetSource(addr, port.intValue());
    }

    public static void clearThreadMetaData() {
        PdmThreadLocalMarker.instance().clear();
    }

    public static String formatErrorMessageForPdmMnemonic(String msg) {
        msg = StringUtils.defaultString((String)msg);
        msg = PdmTextEncoder.encode((String)msg);
        msg = msg.replaceAll("\\s*\\R+", ". ");
        msg = StringUtils.abbreviate((String)msg, (int)250);
        return msg;
    }
}

