/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.hw_runtime;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import de.rtb.pcon.core.services.pdm_in.PdmMessageDto;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.PdmHwStatus;
import de.rtb.pcon.repositories.PdmHwStatusRepository;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class HardwareRuntimeMonitorService {
    @Autowired
    @Qualifier(value="pdmObjectMapper")
    private ObjectMapper pdmObjectMapper;
    @Autowired
    private ObjectMapper stdObjectMapper;
    @Autowired
    private PdmHwStatusRepository pdmHardwareRepo;

    @Transactional
    public void processRuntimeReport(PdmMessageDto m) {
        if (m.getSdl() == null) {
            return;
        }
        String report = m.getSdl();
        ObjectNode pdmRootNode = this.parsePdmReport(report);
        PdmHwStatus dbReportEntity = this.pdmHardwareRepo.findByPdm(m.getPdm()).orElseGet(() -> (PdmHwStatus)this.pdmHardwareRepo.save((Object)PdmHwStatus.fromPdm((Pdm)m.getPdm())));
        ObjectNode dbRootNode = this.parseDbReport(dbReportEntity.getStatus());
        String operation = pdmRootNode.at("/@meta/op").asText("put").toLowerCase();
        pdmRootNode.remove("@meta");
        try {
            switch (operation) {
                case "add": {
                    pdmRootNode.fields().forEachRemaining(entry -> dbRootNode.set((String)entry.getKey(), (JsonNode)entry.getValue()));
                    dbReportEntity.setStatus(this.stdObjectMapper.writeValueAsString((Object)dbRootNode));
                    break;
                }
                case "del": {
                    pdmRootNode.fieldNames().forEachRemaining(arg_0 -> ((ObjectNode)dbRootNode).remove(arg_0));
                    dbReportEntity.setStatus(this.stdObjectMapper.writeValueAsString((Object)dbRootNode));
                    break;
                }
                default: {
                    dbReportEntity.setStatus(this.stdObjectMapper.writeValueAsString((Object)pdmRootNode));
                    break;
                }
            }
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Can't store hardware runtime", e);
        }
    }

    private ObjectNode parsePdmReport(String report) {
        try {
            return (ObjectNode)this.pdmObjectMapper.readTree(report);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("Runtime hardware report from PDM could not be parsed.", e);
        }
    }

    private ObjectNode parseDbReport(String report) {
        try {
            if (StringUtils.isBlank((CharSequence)report)) {
                return this.stdObjectMapper.createObjectNode();
            }
            return (ObjectNode)this.stdObjectMapper.readTree(report);
        }
        catch (JsonProcessingException e) {
            throw new IllegalStateException("DB hardware report could not be parsed", e);
        }
    }
}

