/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.gdpr;

import de.rtb.pcon.model.UserRole;
import java.util.Collection;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.stereotype.Service;

@Service
public class GdprService {
    @Autowired
    private UserDetailsService userDetailService;

    public boolean isLpnAllowed() {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return this.hasLpnAuthority(authentication.getAuthorities());
    }

    public boolean isLpnAllowed(String userName) {
        UserDetails userDetails = this.userDetailService.loadUserByUsername(userName);
        return this.hasLpnAuthority(userDetails.getAuthorities());
    }

    public boolean isLpnProtected() {
        return !this.isLpnAllowed();
    }

    public boolean isLpnProtected(String userName) {
        return !this.isLpnAllowed(userName);
    }

    private boolean hasLpnAuthority(Collection<? extends GrantedAuthority> authorities) {
        return authorities.stream().anyMatch(a -> UserRole.ROLE_PCON_VIEW_LPN.name().equals(a.getAuthority()));
    }
}

