/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.fw_download;

import de.rtb.pcon.config.DevelopmentProperties;
import de.rtb.pcon.core.fw_download.DownloadRequestManager;
import de.rtb.pcon.core.fw_download.DownloadRequestManagerPlatfromThreads;
import de.rtb.pcon.core.fw_download.DownloadRequestManagerVirtualThreads;
import de.rtb.pcon.core.fw_download.FirmwareDownloadServiceIp;
import de.rtb.pcon.core.fw_download.TransferStatus;
import de.rtb.pcon.core.fw_download.WanProps;
import de.rtb.pcon.core.integration.BlockingCallGuard;
import de.rtb.pcon.core.services.pdm_in.PdmMessageDto;
import de.rtb.pcon.core.services.pdm_in.ServerResponseBuilder;
import de.rtb.pcon.core.services.pdm_in.SoftwareDataProvider;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.download.DownloadEntry;
import de.rtb.pcon.model.download.DownloadPlan;
import de.rtb.pcon.model.download.DownloadStatus;
import de.rtb.pcon.model.download.DownloadTarget;
import de.rtb.pcon.model.download.SoftwareItem;
import jakarta.annotation.PostConstruct;
import java.time.Duration;
import java.time.LocalDate;
import java.util.Optional;
import org.apache.commons.lang3.ArrayUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pdmFirmwareDownloadTcp")
public class FirmwareDownloadServiceTcp
extends FirmwareDownloadServiceIp {
    private static final Logger logger = LoggerFactory.getLogger(FirmwareDownloadServiceTcp.class);
    private static final Duration INACTIVITY_TIME_OUT = Duration.ofMinutes(10L);
    @Autowired
    private SoftwareDataProvider swDataProvider;
    @Autowired
    private BlockingCallGuard blockingGuardService;
    @Autowired
    private DevelopmentProperties devProps;
    private DownloadRequestManager downloadRequestManager;

    public FirmwareDownloadServiceTcp(WanProps config) {
        super(config.getIp(), config.getTcpPort());
    }

    @PostConstruct
    public void startup() {
        if (this.devProps.isVirtualThreads()) {
            this.downloadRequestManager = new DownloadRequestManagerVirtualThreads();
        } else {
            int maxDownloadThreads = this.blockingGuardService.getNumberOfTcpDownloadThreads();
            this.downloadRequestManager = new DownloadRequestManagerPlatfromThreads(maxDownloadThreads, INACTIVITY_TIME_OUT);
        }
    }

    public void checkDownload(Pdm pdm, ServerResponseBuilder response) {
        if (this.downloadRequestManager.canDownloadStart()) {
            super.checkDownload(pdm, response);
            if (response.containsMnemonic("WIW")) {
                this.downloadRequestManager.updateState(pdm, TransferStatus.WIW);
            }
        }
    }

    @Transactional
    public void getMetaData(PdmMessageDto m, ServerResponseBuilder response) {
        Optional downloadItem = this.getFirmwareDescription(m.getPdm(), DownloadTarget.fromUty((int)m.getUty()));
        if (downloadItem.isPresent()) {
            DownloadEntry di = (DownloadEntry)downloadItem.get();
            DownloadPlan plan = di.getPlan();
            SoftwareItem swi = this.swDataProvider.getSoftwareItem(di.getPlan().getSoftwareDescription(), di.getPath());
            this.appendFwMetaDataToResponse(response, plan.getDownloadTarget(), swi.getLength(), plan.getActivationDate(), swi.getCrc());
            di.setStatus(DownloadStatus.IN_PROGRESS);
        } else {
            logger.warn("Requested download item doesn't exist. Sending fake data.");
            this.appendFwMetaDataToResponse(response, DownloadTarget.fromUty((int)m.getUty()), 0, LocalDate.now().minusDays(7L), "0000");
        }
        this.downloadRequestManager.updateState(m.getPdm(), TransferStatus.META_DATA);
    }

    private void appendFwMetaDataToResponse(ServerResponseBuilder response, DownloadTarget dt, int fileSizeInBytes, LocalDate activatDate, String crc) {
        response.append("UTY", dt.uty());
        response.append("DGA", activatDate.format(DGA_TIME_FORMATTER));
        response.append("AFB", Integer.toHexString(fileSizeInBytes).toUpperCase());
        response.append("FCC", crc);
    }

    @Transactional
    public void getFilePart(PdmMessageDto m, ServerResponseBuilder response) {
        DownloadTarget dt = DownloadTarget.fromUty((int)m.getUty());
        Pdm pdm = m.getPdm();
        byte[] filePart = this.getFirmwareDescription(pdm, dt).map(de -> this.getFilePartData(pdm, dt, m.getFsa().intValue(), m.getFsi().intValue(), de.getPath())).orElse(ArrayUtils.EMPTY_BYTE_ARRAY);
        response.append(filePart);
        this.downloadRequestManager.updateState(m.getPdm(), TransferStatus.DATA);
    }

    public void updateTransferStatus(PdmMessageDto m, DownloadTarget dt) {
        short messageNumber = m.getMnr();
        if (messageNumber == 225 || messageNumber == 256) {
            this.downloadRequestManager.updateState(m.getPdm(), TransferStatus.DONE);
        }
        super.updateTransferStatus(m, dt);
    }
}

