/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.fw_download;

import de.rtb.pcon.core.fw_download.ActiveDownloadNotificationProperties;
import de.rtb.pcon.core.fw_download.ActiveDownloadNotificationService;
import de.rtb.pcon.core.fw_download.FirmwareDownloadService;
import de.rtb.pcon.core.fw_download.FirmwareDownloadServiceFactory;
import de.rtb.pcon.core.integration.IntegrationConsts;
import de.rtb.pcon.core.notification.NotificationService;
import de.rtb.pcon.core.services.pdm_in.ServerResponse;
import de.rtb.pcon.core.services.pdm_in.ServerResponseBuilder;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.download.DownloadEntry;
import de.rtb.pcon.model.download.DownloadStatus;
import de.rtb.pcon.repositories.fw_update.DownloadEntryRepository;
import de.rtb.pcon.repositories.pdm.PdmRepository;
import de.rtb.pcontrol.utils.DateTimeFormats;
import de.rtb.pcontrol.utils.DateTimeUtils;
import de.rtb.pcontrol.utils.LoggerUtils;
import jakarta.annotation.PostConstruct;
import java.time.Clock;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DurationFormatUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="pdmDownloadNotificator")
public class ActiveDownloadNotificationService {
    private static final Logger logger = LoggerFactory.getLogger(ActiveDownloadNotificationService.class);
    private FirmwareDownloadServiceFactory fwdsFactory;
    private NotificationService notificationService;
    private ActiveDownloadNotificationProperties smsNotificationProps;
    private PdmRepository pdmRepo;
    private DownloadEntryRepository downloadEntryRepo;
    private Duration smsTimeOut = Duration.ofDays(2L);
    private Clock utcClock;
    private Map<Integer, NotificationInfo> sentNotifications;

    @Autowired
    public ActiveDownloadNotificationService(FirmwareDownloadServiceFactory fwdsFactory, NotificationService notificationService, ActiveDownloadNotificationProperties smsNotificationProps, PdmRepository pdmRepo, DownloadEntryRepository downloadEntryRepo) {
        this.fwdsFactory = fwdsFactory;
        this.notificationService = notificationService;
        this.smsNotificationProps = smsNotificationProps;
        this.pdmRepo = pdmRepo;
        this.downloadEntryRepo = downloadEntryRepo;
        this.sentNotifications = new ConcurrentHashMap();
        this.utcClock = Clock.systemUTC();
    }

    public ActiveDownloadNotificationService(ActiveDownloadNotificationProperties smsNotificationProps, DownloadEntryRepository downloadEntryRepo, PdmRepository pdmRepo) {
        this.smsNotificationProps = smsNotificationProps;
        this.downloadEntryRepo = downloadEntryRepo;
        this.pdmRepo = pdmRepo;
        this.sentNotifications = new ConcurrentHashMap();
    }

    @PostConstruct
    void init() {
        if (logger.isInfoEnabled()) {
            String delay = DurationFormatUtils.formatDurationWords((long)this.smsNotificationProps.getInitialDelay().toMillis(), (boolean)true, (boolean)true);
            String interval = DurationFormatUtils.formatDurationWords((long)this.smsNotificationProps.getPolingDelay().toMillis(), (boolean)true, (boolean)true);
            logger.info("Starting SMS download notification service with initial delay {} and interval {}.", (Object)delay, (Object)interval);
        }
    }

    @Transactional
    @Scheduled(initialDelayString="#{activeDownloadNotificationProperties.initialDelay}", fixedDelayString="#{activeDownloadNotificationProperties.polingDelay}")
    public synchronized void run() {
        try {
            Object awaitingLabels;
            String acceptedPdmsLabels;
            List pdmIdsToNotify = this.downloadEntryRepo.listPdmIdWdithPlannedUpdate();
            List<Pdm> pdmsToNotify = this.pdmRepo.findAllById((Iterable)pdmIdsToNotify);
            if (pdmsToNotify.isEmpty()) {
                logger.debug("Running active notification task. Nothing needs to be done.");
            } else if (logger.isInfoEnabled()) {
                Comparator<Pdm> pdmAreaAndNumberComparator = Comparator.comparingInt(pdm -> pdm.getZone().getArea().getId()).thenComparing(Comparator.comparingInt(Pdm::getNumber));
                String pdmsToNotifyString = pdmsToNotify.stream().sorted(pdmAreaAndNumberComparator).map(p -> p.getNumber() + "@" + p.getZone().getArea().getId()).collect(Collectors.joining(", "));
                logger.info("Running active notification task. Found {} updates: {}.", (Object)pdmsToNotify.size(), (Object)pdmsToNotifyString);
            }
            Set pdmIdsWithPlannedUpdate = pdmsToNotify.stream().map(Pdm::getId).collect(Collectors.toSet());
            Set acceptedNotificationIds = this.sentNotifications.keySet().stream().filter(pid -> !pdmIdsWithPlannedUpdate.contains(pid)).collect(Collectors.toSet());
            if (logger.isDebugEnabled() && !acceptedNotificationIds.isEmpty() && StringUtils.isNotBlank((CharSequence)(acceptedPdmsLabels = this.downloadEntryRepo.listSortedPdmLabels(acceptedNotificationIds).stream().collect(Collectors.joining(", "))))) {
                logger.debug("Download accepted by: {}", (Object)acceptedPdmsLabels);
            }
            this.sentNotifications.keySet().removeAll(acceptedNotificationIds);
            if (logger.isDebugEnabled() && !this.sentNotifications.isEmpty() && StringUtils.isNotBlank((CharSequence)(awaitingLabels = this.downloadEntryRepo.listSortedPdmLabels(this.sentNotifications.keySet()).stream().collect(Collectors.joining(", "))))) {
                logger.info("Awaiting feedback from: {}", awaitingLabels);
            }
            pdmsToNotify = pdmsToNotify.stream().filter(p -> !this.sentNotifications.keySet().contains(p.getId())).limit(this.getChunkSize()).toList();
            for (Pdm pdm2 : pdmsToNotify) {
                String pdmPhoneNumber = pdm2.getPhoneNumber();
                if (StringUtils.isBlank((CharSequence)pdmPhoneNumber)) {
                    if (logger.isInfoEnabled()) {
                        logger.info("{} cannot be notified. Phone number is missing. Its download entries will be marked as aborted.", (Object)StringUtils.capitalize((String)LoggerUtils.log((Pdm)pdm2)));
                    }
                    List entriesToAbort = this.downloadEntryRepo.findEntriesReadyToBeDownloadedForPdm(pdm2.getId().intValue());
                    this.downloadEntryRepo.setEntriesStatus((Collection)entriesToAbort, DownloadStatus.ABORTED);
                    continue;
                }
                this.sendWiwSms(pdm2);
                if (logger.isInfoEnabled()) {
                    logger.info("An SMS update notification sent to {}", (Object)LoggerUtils.logPdmAndArea((Pdm)pdm2));
                }
                this.sentNotifications.put(pdm2.getId(), new NotificationInfo(this.utcClock));
            }
            Iterator sentNotificationsIterator = this.sentNotifications.entrySet().iterator();
            while (sentNotificationsIterator.hasNext()) {
                Map.Entry entry = sentNotificationsIterator.next();
                if (((NotificationInfo)entry.getValue()).created.plus(this.smsTimeOut).compareTo(LocalDateTime.now(this.utcClock)) > 0) continue;
                this.failDownload((Integer)entry.getKey());
                sentNotificationsIterator.remove();
            }
        }
        catch (Exception e) {
            logger.error("Cannot execute PDM notification.", (Throwable)e);
        }
    }

    void sendWiwSms(Pdm pdm) {
        FirmwareDownloadService fds = this.fwdsFactory.getService("UDP");
        ServerResponseBuilder responseBuilder = new ServerResponseBuilder(IntegrationConsts.PDM_MESSAGE_ENCODING);
        responseBuilder.append("PSA", pdm.getNumber().intValue());
        responseBuilder.append("GAC", String.format("%05d", pdm.getZone().getArea().getId()));
        LocalDateTime pdmNow = ZonedDateTime.now(ZoneId.of(pdm.getZone().getArea().getTimeZoneName())).toLocalDateTime();
        responseBuilder.append("TIM", pdmNow.toLocalTime().format(DateTimeFormats.PDM_TIME_FORMATTER));
        responseBuilder.append("DAT", pdmNow.toLocalDate().format(DateTimeFormats.PDM_DATE_FORMATTER));
        fds.checkDownload(pdm, responseBuilder);
        ServerResponse serverResponse = responseBuilder.build();
        String smsText = serverResponse.toString();
        logger.info("Download notification for PDM {}@{} ({}) was sent: '{}'.", new Object[]{pdm.getNumber(), pdm.getZone().getArea().getId(), pdm.getPhoneNumber(), smsText});
        this.notificationService.sendSms(pdm.getPhoneNumber(), smsText);
    }

    void failDownload(Integer pdmId) {
        List entriesToFail = this.downloadEntryRepo.findEntriesReadyToBeDownloadedForPdm(pdmId.intValue());
        if (!entriesToFail.isEmpty()) {
            this.downloadEntryRepo.setEntriesStatus((Collection)entriesToFail, DownloadStatus.TRANSFER_FAILED);
            if (logger.isWarnEnabled()) {
                Pdm pdm = (Pdm)this.pdmRepo.findById((Object)pdmId).orElseThrow();
                List<Integer> idsToFail = entriesToFail.stream().map(DownloadEntry::getId).sorted().toList();
                logger.warn("All downloads for {} with activation time older then {} was marked as {} because the PDM did not respond within {} hours. Ids:{} ", new Object[]{LoggerUtils.log((Pdm)pdm), DateTimeUtils.serverNowO(), DownloadStatus.TRANSFER_FAILED, this.smsTimeOut.toHours(), idsToFail});
            }
        }
    }

    public int getChunkSize() {
        return this.smsNotificationProps.getMaxDownloads();
    }

    void setUtcClock(Clock clock) {
        this.utcClock = clock;
    }

    public Duration getSmsTimeOut() {
        return this.smsTimeOut;
    }

    public void setSmsTimeOut(Duration smsTimeOut) {
        this.smsTimeOut = smsTimeOut;
    }
}

