/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.core.controller;

import de.rtb.pcon.config.CompatibilityProperties;
import java.sql.SQLTransientConnectionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.ExitCodeGenerator;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.NestedExceptionUtils;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;

@ControllerAdvice
@ConditionalOnProperty(name={"pcon.compatibility.exit-on-exception"}, havingValue="true")
public class ExitExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(ExitExceptionHandler.class);
    private final ConfigurableApplicationContext context;

    ExitExceptionHandler(ConfigurableApplicationContext context, CompatibilityProperties cp) {
        log.info("ExitExceptionHandler activated.");
        this.context = context;
    }

    @ExceptionHandler(value={SQLTransientConnectionException.class})
    public String handleException1(Exception ex) {
        Throwable theException = NestedExceptionUtils.getMostSpecificCause((Throwable)ex);
        boolean connectinPoolError = theException.getMessage().toLowerCase().contains("connection is not available");
        if (connectinPoolError) {
            log.error("Non-recoverable error. Exiting application.", (Throwable)ex);
            System.exit(SpringApplication.exit((ApplicationContext)this.context, (ExitCodeGenerator[])new ExitCodeGenerator[0]));
        }
        return "";
    }
}

