/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.api.enforcement.v1.dao;

import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlElementWrapper;
import com.fasterxml.jackson.dataformat.xml.annotation.JacksonXmlProperty;
import de.rtb.pcon.api.enforcement.v1.dao.EnfAreaDao;
import de.rtb.pcon.api.enforcement.v1.dao.EnfZoneDao;
import de.rtb.pcon.model.Area;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.List;
import java.util.stream.Collectors;

@Schema(name="AreaAndZones", description="Area with zones")
public class EnfAreaWithZonesDao
extends EnfAreaDao {
    @Schema(description="Zones available for enforcement")
    @JacksonXmlElementWrapper(localName="zones")
    @JacksonXmlProperty(localName="zone")
    private List<EnfZoneDao> zones;

    public EnfAreaWithZonesDao(Area area) {
        super(area);
        this.zones = area.getZones().stream().filter(EnfZoneDao.enforecmentEnabled).map(EnfZoneDao::new).collect(Collectors.toList());
    }

    public List<EnfZoneDao> getZones() {
        return this.zones;
    }
}

