/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcontrol.pdm.fw5parser;

import de.rtb.pcon.core.integration.Crc16;
import de.rtb.pcontrol.pdm.fw5parser.Fw5VersionInfo;
import de.rtb.pcontrol.pdm.fw5parser.SourceLine;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.TreeMap;
import org.apache.commons.codec.DecoderException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Pdm5FwProcessor {
    private static final Logger logger = LoggerFactory.getLogger(Pdm5FwProcessor.class);
    private static final String MAGIC_WORD = "superkallifragelistikexpialigetisch";
    private StringBuffer magicSearchBuffer = new StringBuffer("superkallifragelistikexpialigetisch".length() + 10);
    private Fw5VersionInfo info;
    private String crc;

    public void convert(Reader txtInput, OutputStream binData) throws IOException {
        TreeMap<Integer, byte[]> binFirmwareMap = new TreeMap<Integer, byte[]>();
        int lineNumber = 1;
        try (BufferedReader reader = new BufferedReader(txtInput);){
            String line;
            SourceLine sl = new SourceLine();
            int offset = 0;
            block13: while ((line = reader.readLine()) != null) {
                ++lineNumber;
                sl.parse(line);
                switch (sl.getType()) {
                    case 0: {
                        int address = offset + sl.getAddress();
                        binFirmwareMap.put(address, sl.getData());
                        if (this.info != null) continue block13;
                        this.info = this.searchVersion(sl.getData());
                        continue block13;
                    }
                    case 1: {
                        logger.debug("End of file");
                        continue block13;
                    }
                    case 2: {
                        offset = SourceLine.bytesToUnsignedInt((byte[])sl.getData());
                        offset <<= 4;
                        continue block13;
                    }
                    case 4: {
                        offset = SourceLine.bytesToUnsignedInt((byte[])sl.getData());
                        offset <<= 16;
                        continue block13;
                    }
                }
                throw new IOException("Unexpected record type " + sl.getType());
            }
        }
        catch (IOException | DecoderException e) {
            throw new IOException("Cannot parse firmware file on line " + lineNumber + ". " + e.getMessage());
        }
        Crc16 crc16 = new Crc16();
        int lastAddress = (Integer)binFirmwareMap.keySet().iterator().next();
        for (Integer address : binFirmwareMap.keySet()) {
            if (address - lastAddress > 0) {
                byte[] filler = new byte[address - lastAddress];
                Arrays.fill(filler, (byte)-1);
                binData.write(filler);
                crc16.addBytes(filler);
                lastAddress += filler.length;
            }
            byte[] data = (byte[])binFirmwareMap.get(address);
            binData.write(data);
            crc16.addBytes(data);
            lastAddress += data.length;
        }
        this.crc = Crc16.numberCrcToString((int)crc16.getCrc());
    }

    public Fw5VersionInfo getInfo() {
        return this.info;
    }

    public String getCrc() {
        return this.crc;
    }

    public Fw5VersionInfo searchVersion(byte[] data) {
        String txtData = new String(data, StandardCharsets.ISO_8859_1);
        for (char c : txtData.toCharArray()) {
            if (this.magicSearchBuffer.capacity() == this.magicSearchBuffer.length()) {
                this.magicSearchBuffer.deleteCharAt(0);
            }
            this.magicSearchBuffer.append(c);
            if (!this.magicSearchBuffer.toString().startsWith(MAGIC_WORD)) continue;
            byte[] magicSearchBufferBytes = this.magicSearchBuffer.toString().getBytes(StandardCharsets.ISO_8859_1);
            byte[] versionBytes = Arrays.copyOfRange(magicSearchBufferBytes, MAGIC_WORD.length() + 1, magicSearchBufferBytes.length);
            ByteBuffer bb = ByteBuffer.wrap(versionBytes).order(ByteOrder.LITTLE_ENDIAN);
            float version = bb.getFloat();
            byte day = bb.get();
            byte month = bb.get();
            byte year = bb.get();
            String type = this.magicSearchBuffer.toString().substring(this.magicSearchBuffer.toString().length() - 2);
            Fw5VersionInfo result = new Fw5VersionInfo(version, day, month, year, type);
            logger.debug(result.toString());
            return result;
        }
        return null;
    }
}

