/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.utils.controllers.excel;

import com.github.pjfanning.xlsx.StreamingReader;
import de.rtb.pcon.ui.services.I18nService;
import de.rtb.pcon.ui.utils.controllers.excel.ExcelImportException;
import de.rtb.pcon.ui.utils.controllers.excel.ExcelProcessingException;
import de.rtb.pcon.ui.utils.controllers.excel.ExcelUploadResult;
import jakarta.persistence.PersistenceException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Optional;
import java.util.Set;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.poi.EncryptedDocumentException;
import org.apache.poi.ooxml.POIXMLException;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ExcelProcessingUtilsService {
    private static final Logger logger = LoggerFactory.getLogger(ExcelProcessingUtilsService.class);
    @Autowired
    private I18nService i18n;

    public ResponseEntity<ExcelUploadResult> handleExcelImportException(ExcelProcessingException ex) {
        Throwable exCause = ex.getCause();
        if (ExcelImportException.class.equals(exCause.getClass())) {
            logger.error("Excel import failed.", exCause);
            ExcelImportException e = (ExcelImportException)exCause;
            return new ResponseEntity((Object)new ExcelUploadResult(this.i18n.getLocalizedMessage("document.import.excel.error.cell", new Object[]{e.getExcelCellAdress(), e.getMessage()})), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        if (EncryptedDocumentException.class.equals(exCause.getClass())) {
            logger.error("Cannot read encrypted document.", exCause);
            return new ResponseEntity((Object)new ExcelUploadResult(this.i18n.getLocalizedMessage("document.import.error.encrypted", new Object[0])), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        if (InvalidFormatException.class.equals(exCause.getClass())) {
            logger.error("Document format is invalid.", exCause);
            return new ResponseEntity((Object)new ExcelUploadResult(this.i18n.getLocalizedMessage("document.import.error.notReadable", new Object[]{exCause.getMessage()})), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        if (POIXMLException.class.equals(exCause.getClass())) {
            logger.error("General POI exception.", exCause);
            return new ResponseEntity((Object)new ExcelUploadResult(this.i18n.getLocalizedMessage("document.import.error.notReadable", new Object[]{ExceptionUtils.getRootCauseMessage((Throwable)exCause)})), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        if (IOException.class.equals(exCause.getClass())) {
            logger.error("IO Exception.", exCause);
            return new ResponseEntity((Object)new ExcelUploadResult(this.i18n.getLocalizedMessage("document.import.error.notReadable", new Object[]{ExceptionUtils.getRootCauseMessage((Throwable)exCause)})), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        if (PersistenceException.class.equals(exCause.getClass())) {
            logger.error("Entity cannot be saved. {}.", (Object)ExceptionUtils.getRootCauseMessage((Throwable)exCause));
            return new ResponseEntity((Object)new ExcelUploadResult(this.i18n.getLocalizedMessage("document.import.error.jpa", new Object[]{ExceptionUtils.getRootCauseMessage((Throwable)exCause)})), (HttpStatusCode)HttpStatus.BAD_REQUEST);
        }
        logger.error("Unknown problem.", exCause);
        return new ResponseEntity((Object)new ExcelUploadResult(ExceptionUtils.getRootCauseMessage((Throwable)exCause)), (HttpStatusCode)HttpStatus.BAD_REQUEST);
    }

    public Optional<ResponseEntity<ExcelUploadResult>> validateEcxelUpload(MultipartFile file) {
        if (file == null || file.getName().isEmpty() || file.getSize() == 0L) {
            logger.error("Provided file is empty.");
            return Optional.of(new ResponseEntity((Object)new ExcelUploadResult(this.i18n.getLocalizedMessage("document.import.error.noFile", new Object[0])), (HttpStatusCode)HttpStatus.BAD_REQUEST));
        }
        String userFileExtension = FilenameUtils.getExtension((String)file.getOriginalFilename()).toLowerCase();
        if (!Set.of("xls", "xlsx").contains(userFileExtension)) {
            logger.error("Provided file is not excel.");
            return Optional.of(new ResponseEntity((Object)new ExcelUploadResult(this.i18n.getLocalizedMessage("document.import.error.onlyExcel", new Object[0])), (HttpStatusCode)HttpStatus.BAD_REQUEST));
        }
        return Optional.empty();
    }

    public Workbook openWorkbookForStreaming(MultipartFile file) throws ExcelProcessingException {
        Workbook workbook;
        try {
            workbook = FilenameUtils.getExtension((String)file.getOriginalFilename()).equalsIgnoreCase("xlsx") ? StreamingReader.builder().rowCacheSize(100).bufferSize(4096).open(file.getInputStream()) : WorkbookFactory.create((InputStream)file.getInputStream());
        }
        catch (Exception e) {
            throw new ExcelProcessingException("Cannot open excel document", (Throwable)e);
        }
        return workbook;
    }
}

