/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.services;

import de.rtb.pcon.model.AlertType;
import de.rtb.pcon.model.Area;
import de.rtb.pcon.model.Pdm;
import de.rtb.pcon.model.PdmStatus;
import de.rtb.pcon.model.zone.EnforcementMode;
import de.rtb.pcon.model.zone.Zone;
import de.rtb.pcon.repositories.AreaRepository;
import de.rtb.pcon.repositories.PdmHwDevicesRepository;
import de.rtb.pcon.repositories.PdmStatusRepository;
import de.rtb.pcon.repositories.ZoneRepository;
import de.rtb.pcon.repositories.pdm.PdmRepository;
import de.rtb.pcon.ui.services.SecurityService;
import de.rtb.pcontrol.ui.service.results.ResultPdmWithAlertStatus;
import jakarta.persistence.EntityManager;
import jakarta.persistence.PersistenceContext;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

@Repository
public class PdmService {
    private static final Logger logger = LoggerFactory.getLogger(PdmService.class);
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private PdmRepository pdmRepo;
    @Autowired
    private AreaRepository areaRepo;
    @Autowired
    private ZoneRepository zoneRepo;
    @Autowired
    private PdmHwDevicesRepository hwDeviceRepo;
    @Autowired
    private SecurityService securityService;
    @Autowired
    private PdmStatusRepository pdmStatusRepo;

    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public Pdm createPdm(int pdmNumber, int areaNumber) {
        Area area = this.areaRepo.findById((Object)areaNumber).orElseGet(() -> this.createArea(areaNumber));
        Zone zone = area.getZones().stream().filter(Zone::getIsDefaultZone).findAny().orElseGet(() -> (Zone)area.getZones().get(0));
        Pdm pdm = new Pdm();
        pdm.setNumber(Integer.valueOf(pdmNumber));
        pdm.setName(Integer.toString(pdmNumber));
        pdm.setZone(zone);
        this.pdmRepo.save((Object)pdm);
        logger.info("New PDM number {} in area {} was automatically created.", (Object)pdmNumber, (Object)areaNumber);
        return pdm;
    }

    Area createArea(int number) {
        Area area = new Area();
        area.setId(Integer.valueOf(number));
        area.setName(Integer.toString(number));
        area.setTimeZoneName(ZoneId.systemDefault().getId());
        this.areaRepo.save((Object)area);
        Zone zone = new Zone();
        zone.setArea(area);
        zone.setName(area.getName());
        zone.setColor("#f0f0f0");
        zone.setEnforcementMode(EnforcementMode.DISABLED);
        zone.setIsDefaultZone(Boolean.valueOf(true));
        this.zoneRepo.save((Object)zone);
        logger.info("New area number {} was automatically created.", (Object)number);
        area.setZones(List.of(zone));
        return area;
    }

    @Transactional(readOnly=true)
    public Optional<Pdm> findPdmByNumberAndCpuId(int pdmNumber, String cpuId) {
        return this.hwDeviceRepo.findPdmByNumberAndCpuId(pdmNumber, cpuId);
    }

    public List<ResultPdmWithAlertStatus> getPdmWithAlertStatus(Collection<Integer> pdmIds) {
        ArrayList<ResultPdmWithAlertStatus> result = new ArrayList<ResultPdmWithAlertStatus>();
        if (pdmIds.isEmpty()) {
            return List.of();
        }
        List pdms = this.entityManager.createQuery("SELECT new de.rtb.pcontrol.ui.service.results.ResultPdmWithAlertStatus(pdm.id, pdm.number, pdm.name, pdm.zone.area.id, pdm.zone.area.name, pdm.latitude, pdm.longitude) FROM Pdm pdm JOIN pdm.zone z WHERE pdm.id in (:pdmIds) ORDER BY pdm.zone.area.id, pdm.number", ResultPdmWithAlertStatus.class).setParameter("pdmIds", pdmIds).getResultList();
        List pdmWithAlerts = this.entityManager.createNativeQuery("SELECT pds_pdm_id AS pdmId, MAX(mcd_alert) AS max_alert\nFROM control.pdm_status\nJOIN control.message_config_default ON pds_msg_nr = mcd_number\nWHERE pds_pdm_id IN (:pdmIds)\nGROUP BY pds_pdm_id\n").setParameter("pdmIds", pdmIds).getResultList();
        for (ResultPdmWithAlertStatus pdmWithAlert : pdms) {
            Optional<AlertType> alertSearchResult = pdmWithAlerts.stream().filter(p -> pdmWithAlert.getPdmId() == ((Integer)p[0]).intValue()).map(o -> AlertType.valueOf((String)((String)o[1]))).findAny();
            pdmWithAlert.setAlertType(alertSearchResult.orElse(AlertType.NONE));
            result.add(pdmWithAlert);
        }
        return result;
    }

    public Map<AlertType, Integer> countPdmsWithIssue() {
        List userAreas = this.securityService.getCurrentAreas();
        Map<Pdm, AlertType> maxAlertByPdm = this.pdmStatusRepo.findByPdmZoneAreaIn((Collection)userAreas).stream().collect(Collectors.groupingBy(PdmStatus::getPdm, Collectors.mapping(s -> s.getMessageConfig().getAlertType(), Collectors.reducing(AlertType.NONE, BinaryOperator.maxBy((a, b) -> a.ordinal() - b.ordinal())))));
        return maxAlertByPdm.entrySet().stream().collect(Collectors.groupingBy(Map.Entry::getValue, Collectors.summingInt(e -> 1)));
    }

    @Transactional
    public List<Pdm> findAndVerifyUserPdms(Collection<Integer> pdmIds) {
        List pdms = pdmIds == null || pdmIds.isEmpty() ? this.entityManager.createQuery("FROM Pdm p JOIN fetch p.area WHERE :user in elements (p.area.users)", Pdm.class).setParameter("user", (Object)this.securityService.getCurrentUser()).getResultList() : this.entityManager.createQuery("FROM Pdm p JOIN fetch p.area WHERE p.id in (:pdmIds) AND :user in elements (p.area.users)", Pdm.class).setParameter("pdmIds", pdmIds).setParameter("user", (Object)this.securityService.getCurrentUser()).getResultList();
        return pdms;
    }

    @Transactional
    public Pdm findAndVerifyUserPdm(int pdmId) {
        HashSet<Integer> pdmIds = new HashSet<Integer>();
        pdmIds.add(pdmId);
        List pdms = this.findAndVerifyUserPdms(pdmIds);
        if (pdms.isEmpty()) {
            return null;
        }
        return (Pdm)pdms.get(0);
    }
}

