/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.data_tables.export;

import de.rtb.pcon.model.appmanagement.User;
import de.rtb.pcontrol.utils.LoggerUtils;
import jakarta.persistence.EntityManager;
import java.io.File;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.Locale;
import java.util.UUID;
import java.util.function.Supplier;
import org.apache.commons.lang3.ClassUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;

public abstract class UserBackgroundJob
implements Supplier<Void> {
    private static final Logger logger = LoggerFactory.getLogger(UserBackgroundJob.class);
    private User requester;
    private EntityManager entityManager;
    private Locale locale;
    private int totalWork = 0;
    private int doneWork = 0;
    private ApplicationContext applicationContext;
    private File outLocation;

    protected UserBackgroundJob(User user, Locale locale) {
        this.requester = user;
        this.locale = locale;
    }

    protected void addWorkUnits(int workUnits) {
        this.doneWork += workUnits;
    }

    public double getProgress() {
        if (this.doneWork == 0) {
            return -1.0;
        }
        return (double)this.doneWork / (double)this.totalWork * 100.0;
    }

    protected abstract void export();

    @Override
    public Void get() {
        LocalDateTime taskStart = LocalDateTime.now();
        String userLog = "";
        String classNameLog = "";
        if (logger.isDebugEnabled()) {
            userLog = LoggerUtils.log((User)this.getRequester());
            classNameLog = ClassUtils.getShortCanonicalName(this.getClass());
        }
        logger.debug("Started export task '{}' for {}.", (Object)classNameLog, (Object)userLog);
        this.export();
        LocalDateTime tastkEnd = LocalDateTime.now();
        Duration taskTime = Duration.between(taskStart, tastkEnd);
        logger.debug("Finished export task '{}' for {} in {}.", new Object[]{classNameLog, userLog, taskTime});
        return null;
    }

    protected String generateRandomFileName(String prefix, String suffix) {
        return prefix + UUID.randomUUID().toString().replace("-", "") + suffix;
    }

    public User getRequester() {
        return this.requester;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public File getOutLocation() {
        return this.outLocation;
    }

    public void setOutLocation(File outLocation) {
        this.outLocation = outLocation;
    }

    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    public void setEntityManager(EntityManager entityManager) {
        this.entityManager = entityManager;
    }

    public int getTotalWork() {
        return this.totalWork;
    }

    public void setTotalWork(int totalWork) {
        this.totalWork = totalWork;
    }

    public int getDoneWork() {
        return this.doneWork;
    }

    public void setDoneWork(int doneWork) {
        this.doneWork = doneWork;
    }

    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

