/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.data_tables.export;

import de.rtb.pcon.model.appmanagement.User;
import de.rtb.pcon.ui.controllers.PdmFilterRepository;
import de.rtb.pcon.ui.controllers.logbooks.LogbookStatusRepository;
import de.rtb.pcon.ui.data_tables.StatusRequest;
import de.rtb.pcon.ui.data_tables.export.UserBackgroundJob;
import de.rtb.pcon.ui.services.I18nService;
import de.rtb.pcontrol.utils.ExcelOutputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.support.TransactionTemplate;

public class ExportStatusToExcelTask
extends UserBackgroundJob {
    private static final Logger log = LoggerFactory.getLogger(ExportStatusToExcelTask.class);
    private StatusRequest dtRequest;

    public ExportStatusToExcelTask(User user, Locale locale, StatusRequest request) {
        super(user, locale);
        this.dtRequest = request;
    }

    public void export() {
        LogbookStatusRepository logbookRepositoryStatus = (LogbookStatusRepository)this.getApplicationContext().getBean(LogbookStatusRepository.class);
        PdmFilterRepository pdmFilterRepo = (PdmFilterRepository)this.getApplicationContext().getBean(PdmFilterRepository.class);
        I18nService i18nService = (I18nService)this.getApplicationContext().getBean(I18nService.class);
        PlatformTransactionManager platformTransactionManager = (PlatformTransactionManager)this.getApplicationContext().getBean(PlatformTransactionManager.class);
        this.setOutLocation(new File(this.getOutLocation(), this.generateRandomFileName("sts", ".xlsx")));
        try (ExcelOutputStream eos = new ExcelOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(this.getOutLocation())), true);){
            eos.registerDateTimeStyle("dateTimeMin", i18nService.getLocalizedMessageWithLocale("excel.format.datetime.short.minutes", this.getLocale(), new Object[0]));
            eos.registerDateTimeStyle("dateTimeSec", i18nService.getLocalizedMessageWithLocale("excel.format.datetime.short.seconds", this.getLocale(), new Object[0]));
            eos.addSheet(i18nService.getLocalizedMessageWithLocale("excel.emptySheetName", this.getLocale(), new Object[0]));
            eos.writeHeaderRow(new String[]{i18nService.getLocalizedMessageWithLocale("comp.table.header.label.state", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("comp.table.header.label.gacNumber", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("comp.table.header.label.gac", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("comp.table.header.label.pdmNumber", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("comp.table.header.label.pdmName", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("comp.table.header.label.number", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("comp.table.header.label.messageText", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("comp.table.header.label.datePdm", this.getLocale(), new Object[0]), i18nService.getLocalizedMessageWithLocale("comp.table.header.label.dateServer", this.getLocale(), new Object[0])});
            TransactionTemplate transactionTemplate = new TransactionTemplate(platformTransactionManager);
            transactionTemplate.setReadOnly(true);
            transactionTemplate.executeWithoutResult(transactionStatus -> {
                List pdms = pdmFilterRepo.findBySelector(this.dtRequest.getPdmSelector(), this.getRequester());
                try (Stream statusStream = logbookRepositoryStatus.streamStatuses((Collection)pdms, this.dtRequest);){
                    statusStream.forEach(statusMessage -> {
                        eos.addRow();
                        eos.writeCell(i18nService.getEnumLocalText((Enum)statusMessage.getMessageConfig().getAlertType(), this.getLocale()));
                        eos.writeCell((Number)statusMessage.getPdm().getZone().getArea().getId());
                        eos.writeCell(statusMessage.getPdm().getZone().getArea().getName());
                        eos.writeCell((Number)statusMessage.getPdm().getNumber());
                        eos.writeCell(statusMessage.getPdm().getName());
                        eos.writeCell((Number)statusMessage.getMessageConfig().getNumber());
                        eos.writeCell(i18nService.getStatusMessageFullText((int)statusMessage.getMessageConfig().getNumber().shortValue(), statusMessage.getReason(), this.getLocale()));
                        eos.writeOffsetlDateTime(statusMessage.getPdmTime(), "dateTimeMin");
                        eos.writeOffsetlDateTime(statusMessage.getServerTime(), "dateTimeSec");
                        this.getEntityManager().detach(statusMessage);
                    });
                }
            });
        }
        catch (IOException e) {
            log.error("Error by exporting statuses to excel.", (Throwable)e);
        }
    }
}

