/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.reports.revenue;

import de.rtb.pcon.model.PaymentType;
import de.rtb.pcon.ui.controllers.reports.revenue.RevenueEndOfDayRowDto;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;

class RevenueEndOfDayReportDto {
    private List<PaymentType> paymentTypes;
    private List<String> currencies;
    private List<RevenueEndOfDayRowDto> report = new ArrayList();

    public RevenueEndOfDayRowDto createReportRow() {
        RevenueEndOfDayRowDto row = new RevenueEndOfDayRowDto();
        this.report.add(row);
        return row;
    }

    public Integer periodCount(String currency, PaymentType paymentType) {
        return this.report.stream().filter(row -> currency.equals(row.getCurrency())).map(row -> row.getItem(paymentType).getCount()).reduce(0, Integer::sum);
    }

    public BigDecimal periodAmount(String currency, PaymentType paymentType) {
        return this.report.stream().filter(row -> currency.equals(row.getCurrency())).map(row -> row.getItem(paymentType).getAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public Integer periodTotalCount(String currency) {
        return this.report.stream().filter(row -> currency.equals(row.getCurrency())).map(row -> row.getTotalCount()).reduce(0, Integer::sum);
    }

    public BigDecimal periodTotalAmount(String currency) {
        return this.report.stream().filter(row -> currency.equals(row.getCurrency())).map(row -> row.getTotalAmount()).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    public List<PaymentType> getPaymentTypes() {
        return this.paymentTypes;
    }

    public void setPaymentTypes(List<PaymentType> paymentTypes) {
        this.paymentTypes = paymentTypes;
    }

    public List<RevenueEndOfDayRowDto> getReport() {
        return this.report;
    }

    public void setReport(List<RevenueEndOfDayRowDto> report) {
        this.report = report;
    }

    public List<String> getCurrencies() {
        return this.currencies;
    }

    public void setCurrencies(List<String> currencies) {
        this.currencies = currencies;
    }
}

