/*
 * Decompiled with CFR 0.152.
 */
package de.rtb.pcon.ui.controllers.reports.payments;

import de.rtb.pcon.ui.controllers.reports.payments.TableFormatter;
import java.time.Duration;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.time.format.FormatStyle;
import java.util.Locale;

class TimeDurationTableFormatter
implements TableFormatter<LocalTime, Duration> {
    private DateTimeFormatter localTimeFormatter;

    public TimeDurationTableFormatter(Locale locale) {
        this.localTimeFormatter = DateTimeFormatter.ofLocalizedTime(FormatStyle.MEDIUM).withLocale(locale);
    }

    public String formatColHeader(LocalTime value) {
        String formattedTime = this.localTimeFormatter.format(value);
        formattedTime = formattedTime.replaceAll("(\\D*)(\\d+)(\\D\\d+)(\\D\\d+)(\\D*)", "$1$2$3$5");
        return formattedTime;
    }

    public String formatRowHeader(Duration value) {
        long s = value.getSeconds();
        String formattedDuration = String.format("%d:%02d", s / 3600L, s % 3600L / 60L);
        return formattedDuration;
    }

    public String formatCellValue(Integer value) {
        return value.toString();
    }
}

